/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TException;
import com.facebook.thrift.TProcessorEventHandler;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.server.TConnectionContext;
import com.facebook.thrift.transport.THeaderTransport;
import com.facebook.thrift.transport.TTransport;

public class UserExceptionHandler
extends TProcessorEventHandler {
    @Override
    public Object getContext(String fn_name, TConnectionContext connectionContext) {
        TProtocol protocol = connectionContext.getOutputProtocol();
        TTransport transport = protocol.getTransport();
        return transport instanceof THeaderTransport ? transport : null;
    }

    @Override
    public <T extends Throwable> void declaredUserException(Object handler_context, String fn_name, T th) throws TException {
        if (handler_context != null) {
            THeaderTransport headerTransport = (THeaderTransport)handler_context;
            headerTransport.setHeader("uex", th.getClass().getSimpleName());
            String message = th.getMessage();
            if (message != null && !message.isEmpty()) {
                headerTransport.setHeader("uexw", message);
            } else {
                String str = ((TBase)((Object)th)).toString(1, false);
                headerTransport.setHeader("uexw", str);
            }
        }
    }

    @Override
    public void handlerError(Object handler_context, String fn_name, Throwable th) throws TException {
        if (handler_context != null) {
            THeaderTransport headerTransport = (THeaderTransport)handler_context;
            headerTransport.setHeader("uex", th.getClass().getSimpleName());
            headerTransport.setHeader("uexw", th.toString());
        }
    }
}

