/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.sd;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.EurekaSdProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.entity.sd.ConnectionConfig;
import org.apache.hertzbeat.common.entity.sd.EurekaDiscoveryResponseEntity;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.XmlUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EurekaSdCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(EurekaSdCollectImpl.class);
    private static final String APP_LIST_PATH = "/apps";

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        EurekaSdProtocol eurekaSd = metrics.getEureka_sd();
        if (eurekaSd == null || eurekaSd.getUrl() == null) {
            throw new IllegalArgumentException("Eureka Service Discovery url is required.");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        ArrayList configList = Lists.newArrayList();
        HttpUriRequest request = RequestBuilder.get().setUri(metrics.getEureka_sd().getUrl() + APP_LIST_PATH).build();
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn("Failed to fetch eureka sd...");
                builder.setMsg("StatusCode " + statusCode);
                builder.setCode(CollectRep.Code.FAIL);
                return;
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            EurekaDiscoveryResponseEntity responseEntity = (EurekaDiscoveryResponseEntity)XmlUtil.fromXml((String)responseBody, EurekaDiscoveryResponseEntity.class);
            if (responseEntity == null || CollectionUtils.isEmpty((Collection)responseEntity.getApplications())) {
                return;
            }
            responseEntity.getApplications().stream().filter(application -> !CollectionUtils.isEmpty((Collection)application.getInstances())).forEach(application -> this.convertTarget(configList, (EurekaDiscoveryResponseEntity.Application)application));
            configList.forEach(config -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                valueRowBuilder.addColumn(config.getHost());
                valueRowBuilder.addColumn(config.getPort());
                builder.addValueRow(valueRowBuilder.build());
            });
        }
        catch (IOException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("Failed to fetch eureka sd... {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    private void convertTarget(List<ConnectionConfig> configList, EurekaDiscoveryResponseEntity.Application application) {
        application.getInstances().forEach(instance -> {
            String host = instance.getIpAddr();
            int port = instance.getPort() == null ? 80 : instance.getPort();
            configList.add(ConnectionConfig.builder().host(host).port(String.valueOf(port)).build());
        });
    }

    public String supportProtocol() {
        return "eureka_sd";
    }
}

