/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hertzbeat.alert.AlerterWorkerPool;
import org.apache.hertzbeat.alert.config.AlertSseManager;
import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.AlertNotifyHandler;
import org.apache.hertzbeat.alert.notice.AlertStoreHandler;
import org.apache.hertzbeat.alert.service.NoticeConfigService;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeRule;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.plugin.Plugin;
import org.apache.hertzbeat.plugin.PostAlertPlugin;
import org.apache.hertzbeat.plugin.runner.PluginRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlertNoticeDispatch {
    private static final Logger log = LoggerFactory.getLogger(AlertNoticeDispatch.class);
    private final AlerterWorkerPool workerPool;
    private final NoticeConfigService noticeConfigService;
    private final AlertStoreHandler alertStoreHandler;
    private final Map<Byte, AlertNotifyHandler> alertNotifyHandlerMap;
    private final PluginRunner pluginRunner;
    private final AlertSseManager emitterManager;

    public AlertNoticeDispatch(AlerterWorkerPool workerPool, NoticeConfigService noticeConfigService, AlertStoreHandler alertStoreHandler, List<AlertNotifyHandler> alertNotifyHandlerList, PluginRunner pluginRunner, AlertSseManager emitterManager) {
        this.workerPool = workerPool;
        this.noticeConfigService = noticeConfigService;
        this.alertStoreHandler = alertStoreHandler;
        this.pluginRunner = pluginRunner;
        this.alertNotifyHandlerMap = Maps.newHashMapWithExpectedSize((int)alertNotifyHandlerList.size());
        this.emitterManager = emitterManager;
        alertNotifyHandlerList.forEach(r -> this.alertNotifyHandlerMap.put(r.type(), (AlertNotifyHandler)r));
    }

    public boolean sendNoticeMsg(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        if (receiver == null || receiver.getType() == null) {
            log.warn("DispatcherAlarm-sendNoticeMsg params is empty alert:[{}], receiver:[{}]", (Object)alert, (Object)receiver);
            return false;
        }
        byte type = receiver.getType();
        if (this.alertNotifyHandlerMap.containsKey(type)) {
            AlertNotifyHandler alertNotifyHandler = this.alertNotifyHandlerMap.get(type);
            if (noticeTemplate == null) {
                noticeTemplate = this.noticeConfigService.getDefaultNoticeTemplateByType(alertNotifyHandler.type());
            }
            if (noticeTemplate == null && alertNotifyHandler.type() != 0) {
                log.error("alert does not have mapping default notice template. type: {}.", (Object)alertNotifyHandler.type());
                throw new NullPointerException(alertNotifyHandler.type() + " does not have mapping default notice template");
            }
            alertNotifyHandler.send(receiver, noticeTemplate, alert);
            return true;
        }
        return false;
    }

    private NoticeReceiver getOneReceiverById(Long id) {
        return this.noticeConfigService.getReceiverById(id);
    }

    private NoticeTemplate getOneTemplateById(Long id) {
        if (id == null) {
            return null;
        }
        return this.noticeConfigService.getOneTemplateById(id);
    }

    private Optional<List<NoticeRule>> matchNoticeRulesByAlert(GroupAlert alert) {
        return Optional.ofNullable(this.noticeConfigService.getReceiverFilterRule(alert));
    }

    public void dispatchAlarm(GroupAlert groupAlert) {
        if (groupAlert != null) {
            GroupAlert storedGroupAlert = this.alertStoreHandler.store(groupAlert);
            this.sendNotify(storedGroupAlert);
            this.pluginRunner.pluginExecute(Plugin.class, plugin -> plugin.alert(storedGroupAlert));
            this.pluginRunner.pluginExecute(PostAlertPlugin.class, (afterAlertPlugin, pluginContext) -> afterAlertPlugin.execute(storedGroupAlert, pluginContext));
            this.emitterManager.broadcast(JsonUtil.toJson((Object)storedGroupAlert));
        }
    }

    private void sendNotify(GroupAlert alert) {
        this.matchNoticeRulesByAlert(alert).ifPresent(noticeRules -> noticeRules.forEach(rule -> this.workerPool.executeNotify(() -> rule.getReceiverId().forEach(receiverId -> {
            try {
                this.sendNoticeMsg(this.getOneReceiverById((Long)receiverId), this.getOneTemplateById(rule.getTemplateId()), alert);
            }
            catch (AlertNoticeException e) {
                log.warn("DispatchTask sendNoticeMsg error, message: {}", (Object)e.getMessage());
            }
        }))));
    }
}

