/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.apache.hertzbeat.alert.dto.UptimeKumaExternAlert;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UptimeKumaExternAlertServiceImpl
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(UptimeKumaExternAlertServiceImpl.class);
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addExternAlert(String content) {
        UptimeKumaExternAlert alert = (UptimeKumaExternAlert)JsonUtil.fromJson((String)content, UptimeKumaExternAlert.class);
        if (alert == null) {
            log.warn("parse extern alert content failed! content: {}", (Object)content);
            return;
        }
        SingleAlert singleAlert = new UptimeKumaAlertConverter().convert(alert);
        this.alarmCommonReduce.reduceAndSendAlarm(singleAlert);
    }

    @Override
    public String supportSource() {
        return "uptime-kuma";
    }

    public static class UptimeKumaAlertConverter {
        public SingleAlert convert(UptimeKumaExternAlert alert) {
            SingleAlert.SingleAlertBuilder builder = SingleAlert.builder().status(this.convertStatus(alert.getHeartbeat().getStatus())).startAt(this.parseTime(alert.getHeartbeat().getTime())).activeAt(this.parseTime(alert.getHeartbeat().getTime())).triggerTimes(Integer.valueOf(1));
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("__source__", "uptime_kuma");
            labels.put("monitor_id", String.valueOf(alert.getMonitor().getId()));
            labels.put("monitor_name", alert.getMonitor().getName());
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put("description", alert.getMonitor().getDescription());
            annotations.put("message", alert.getHeartbeat().getMsg());
            annotations.put("important", String.valueOf(alert.getHeartbeat().isImportant()));
            return builder.labels(labels).annotations(annotations).content(this.buildContent(alert)).build();
        }

        private String buildContent(UptimeKumaExternAlert alert) {
            return String.format("Monitor [%s] %s: %s", alert.getMonitor().getName(), alert.getMonitor().getDescription(), alert.getHeartbeat().getMsg());
        }

        private String convertStatus(int status) {
            return status == 1 ? "resolved" : "firing";
        }

        private Long parseTime(String timeStr) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sdf.parse(timeStr).getTime();
            }
            catch (ParseException e) {
                log.error("Failed to parse time: {}", (Object)timeStr);
                throw new IllegalArgumentException("Failed to parse time: " + timeStr, e);
            }
        }
    }
}

