/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRouteSource;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.HttpRouteSupport;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

final class WebMvcTelemetryProducingFilter
extends OncePerRequestFilter
implements Ordered {
    private final Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter;
    private final HttpRouteSupport httpRouteSupport = new HttpRouteSupport();

    WebMvcTelemetryProducingFilter(Instrumenter<HttpServletRequest, HttpServletResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void afterPropertiesSet() {
    }

    protected void initFilterBean() {
        this.httpRouteSupport.onFilterInit(Objects.requireNonNull(this.getFilterConfig()));
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        AsyncAwareHttpServletRequest asyncAwareRequest = new AsyncAwareHttpServletRequest(request, response, context);
        Throwable error = null;
        try (Scope ignored = context.makeCurrent();){
            filterChain.doFilter((ServletRequest)asyncAwareRequest, (ServletResponse)response);
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (this.httpRouteSupport.hasMappings()) {
                HttpServerRoute.update((Context)context, (HttpServerRouteSource)HttpServerRouteSource.CONTROLLER, this.httpRouteSupport::getHttpRoute, (Object)request);
            }
            if (error != null || asyncAwareRequest.isNotAsync()) {
                this.instrumenter.end(context, (Object)request, (Object)response, error);
            }
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return -2147483647;
    }

    private class AsyncAwareHttpServletRequest
    extends HttpServletRequestWrapper {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final Context context;
        private final AtomicBoolean listenerAttached;

        AsyncAwareHttpServletRequest(HttpServletRequest request, HttpServletResponse response, Context context) {
            super(request);
            this.listenerAttached = new AtomicBoolean();
            this.request = request;
            this.response = response;
            this.context = context;
        }

        public AsyncContext startAsync() {
            AsyncContext asyncContext = super.startAsync();
            this.attachListener(asyncContext);
            return asyncContext;
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
            AsyncContext asyncContext = super.startAsync(servletRequest, servletResponse);
            this.attachListener(asyncContext);
            return asyncContext;
        }

        private void attachListener(AsyncContext asyncContext) {
            if (!this.listenerAttached.compareAndSet(false, true)) {
                return;
            }
            asyncContext.addListener((AsyncListener)new AsyncRequestCompletionListener(this.request, this.response, this.context), (ServletRequest)this.request, (ServletResponse)this.response);
        }

        boolean isNotAsync() {
            return !this.listenerAttached.get();
        }
    }

    private class AsyncRequestCompletionListener
    implements AsyncListener {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final Context context;
        private final AtomicBoolean responseHandled = new AtomicBoolean();

        AsyncRequestCompletionListener(HttpServletRequest request, HttpServletResponse response, Context context) {
            this.request = request;
            this.response = response;
            this.context = context;
        }

        public void onComplete(AsyncEvent asyncEvent) {
            if (this.responseHandled.compareAndSet(false, true)) {
                WebMvcTelemetryProducingFilter.this.instrumenter.end(this.context, (Object)this.request, (Object)this.response, null);
            }
        }

        public void onTimeout(AsyncEvent asyncEvent) {
            if (this.responseHandled.compareAndSet(false, true)) {
                WebMvcTelemetryProducingFilter.this.instrumenter.end(this.context, (Object)this.request, (Object)this.response, null);
            }
        }

        public void onError(AsyncEvent asyncEvent) {
            if (this.responseHandled.compareAndSet(false, true)) {
                WebMvcTelemetryProducingFilter.this.instrumenter.end(this.context, (Object)this.request, (Object)this.response, asyncEvent.getThrowable());
            }
        }

        public void onStartAsync(AsyncEvent asyncEvent) {
            asyncEvent.getAsyncContext().addListener((AsyncListener)this, asyncEvent.getSuppliedRequest(), asyncEvent.getSuppliedResponse());
        }
    }
}

