/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.jsonwebtoken.ExpiredJwtException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Map;
import javax.naming.AuthenticationException;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.util.ResponseUtil;
import org.apache.hertzbeat.manager.pojo.dto.LoginDto;
import org.apache.hertzbeat.manager.pojo.dto.RefreshTokenResponse;
import org.apache.hertzbeat.manager.pojo.dto.TokenDto;
import org.apache.hertzbeat.manager.service.AccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Auth Manage API")
@RestController
@RequestMapping(value={"/api/account/auth"}, produces={"application/json"})
public class AccountController {
    private static final Logger log = LoggerFactory.getLogger(AccountController.class);
    @Autowired
    private AccountService accountService;

    @PostMapping(value={"/form"})
    @Operation(summary="Account password login to obtain associated user information", description="Account password login to obtain associated user information")
    public ResponseEntity<Message<Map<String, String>>> authGetToken(@Valid @RequestBody LoginDto loginDto) {
        return ResponseUtil.handle(() -> this.accountService.authGetToken(loginDto));
    }

    @PostMapping(value={"/refresh"})
    @Operation(summary="Use refresh TOKEN to re-acquire TOKEN", description="Use refresh TOKEN to re-acquire TOKEN")
    public ResponseEntity<Message<RefreshTokenResponse>> refreshToken(@Valid @RequestBody TokenDto tokenDto) {
        try {
            return ResponseEntity.ok(Message.success(this.accountService.refreshToken(tokenDto.getToken())));
        }
        catch (AuthenticationException e) {
            return ResponseEntity.ok(Message.fail((byte)5, e.getMessage()));
        }
        catch (ExpiredJwtException expiredJwtException) {
            log.warn("{}", (Object)expiredJwtException.getMessage());
            return ResponseEntity.ok(Message.fail((byte)5, "Refresh Token Expired"));
        }
        catch (Exception e) {
            log.error("Exception occurred during token refresh: {}", (Object)e.getClass().getName(), (Object)e);
            return ResponseEntity.ok(Message.fail((byte)5, "Refresh Token Error"));
        }
    }
}

