/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.HibernateJpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractJpaQuery
implements RepositoryQuery {
    private final JpaQueryMethod method;
    private final EntityManager em;
    private final JpaMetamodel metamodel;
    private final PersistenceProvider provider;
    private final Lazy<JpaQueryExecution> execution;
    final Lazy<ParameterBinder> parameterBinder = Lazy.of(this::createBinder);

    public AbstractJpaQuery(JpaQueryMethod method, EntityManager em) {
        Assert.notNull((Object)((Object)method), (String)"JpaQueryMethod must not be null");
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        this.method = method;
        this.em = em;
        this.metamodel = JpaMetamodel.of(em.getMetamodel());
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.execution = Lazy.of(() -> {
            if (method.isStreamQuery()) {
                return new JpaQueryExecution.StreamExecution();
            }
            if (method.isProcedureQuery()) {
                return new JpaQueryExecution.ProcedureExecution(method.isCollectionQuery());
            }
            if (method.isCollectionQuery()) {
                return new JpaQueryExecution.CollectionExecution();
            }
            if (method.isSliceQuery()) {
                return new JpaQueryExecution.SlicedExecution();
            }
            if (method.isPageQuery()) {
                return new JpaQueryExecution.PagedExecution();
            }
            if (method.isModifyingQuery()) {
                return null;
            }
            return new JpaQueryExecution.SingleEntityExecution();
        });
    }

    public JpaQueryMethod getQueryMethod() {
        return this.method;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    protected JpaMetamodel getMetamodel() {
        return this.metamodel;
    }

    @Nullable
    public Object execute(Object[] parameters) {
        return this.doExecute(this.getExecution(), parameters);
    }

    @Nullable
    private Object doExecute(JpaQueryExecution execution, Object[] values) {
        JpaParametersParameterAccessor accessor = this.obtainParameterAccessor(values);
        Object result = execution.execute(this, accessor);
        ResultProcessor withDynamicProjection = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        return withDynamicProjection.processResult(result, (Converter)new TupleConverter(withDynamicProjection.getReturnedType(), this.method.isNativeQuery()));
    }

    private JpaParametersParameterAccessor obtainParameterAccessor(Object[] values) {
        if (this.method.isNativeQuery() && PersistenceProvider.HIBERNATE.equals(this.provider)) {
            return new HibernateJpaParametersParameterAccessor(this.method.getParameters(), values, this.em);
        }
        return new JpaParametersParameterAccessor(this.method.getParameters(), values);
    }

    protected JpaQueryExecution getExecution() {
        JpaQueryExecution execution = (JpaQueryExecution)this.execution.getNullable();
        if (execution != null) {
            return execution;
        }
        if (this.method.isModifyingQuery()) {
            return new JpaQueryExecution.ModifyingExecution(this.method, this.em);
        }
        return new JpaQueryExecution.SingleEntityExecution();
    }

    protected <T extends Query> T applyHints(T query, JpaQueryMethod method) {
        List<QueryHint> hints = method.getHints();
        if (!hints.isEmpty()) {
            for (QueryHint hint : hints) {
                this.applyQueryHint(query, hint);
            }
        }
        if (method.hasQueryMetaAttributes() && this.provider.getCommentHintKey() != null) {
            query.setHint(this.provider.getCommentHintKey(), (Object)this.provider.getCommentHintValue(method.getQueryMetaAttributes().getComment()));
        }
        return query;
    }

    protected <T extends Query> void applyQueryHint(T query, QueryHint hint) {
        Assert.notNull(query, (String)"Query must not be null");
        Assert.notNull((Object)hint, (String)"QueryHint must not be null");
        query.setHint(hint.name(), (Object)hint.value());
    }

    private Query applyLockMode(Query query, JpaQueryMethod method) {
        LockModeType lockModeType = method.getLockModeType();
        return lockModeType == null ? query : query.setLockMode(lockModeType);
    }

    protected ParameterBinder createBinder() {
        return ParameterBinderFactory.createBinder(this.getQueryMethod().getParameters());
    }

    protected Query createQuery(JpaParametersParameterAccessor parameters) {
        return this.applyLockMode(this.applyEntityGraphConfiguration(this.applyHints(this.doCreateQuery(parameters), this.method), this.method), this.method);
    }

    private Query applyEntityGraphConfiguration(Query query, JpaQueryMethod method) {
        JpaEntityGraph entityGraph = method.getEntityGraph();
        if (entityGraph != null) {
            QueryHints hints = Jpa21Utils.getFetchGraphHint(this.em, entityGraph, this.getQueryMethod().getEntityInformation().getJavaType());
            hints.forEach((arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
        }
        return query;
    }

    protected Query createCountQuery(JpaParametersParameterAccessor values) {
        Query countQuery = this.doCreateCountQuery(values);
        return this.method.applyHintsToCountQuery() ? this.applyHints(countQuery, this.method) : countQuery;
    }

    @Nullable
    protected Class<?> getTypeToRead(ReturnedType returnedType) {
        if (PersistenceProvider.ECLIPSELINK.equals(this.provider)) {
            return null;
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) ? Tuple.class : null;
    }

    protected abstract Query doCreateQuery(JpaParametersParameterAccessor var1);

    protected abstract Query doCreateCountQuery(JpaParametersParameterAccessor var1);

    private static class FallbackTupleWrapper
    implements Tuple {
        private final Tuple delegate;
        private final UnaryOperator<String> fallbackNameTransformer = JdbcUtils::convertPropertyNameToUnderscoreName;

        FallbackTupleWrapper(Tuple delegate) {
            this.delegate = delegate;
        }

        public <X> X get(TupleElement<X> tupleElement) {
            return this.get(tupleElement.getAlias(), tupleElement.getJavaType());
        }

        public <X> X get(String s, Class<X> type) {
            try {
                return (X)this.delegate.get(s, type);
            }
            catch (IllegalArgumentException original) {
                try {
                    return (X)this.delegate.get((String)this.fallbackNameTransformer.apply(s), type);
                }
                catch (IllegalArgumentException next) {
                    original.addSuppressed(next);
                    throw original;
                }
            }
        }

        public Object get(String s) {
            try {
                return this.delegate.get(s);
            }
            catch (IllegalArgumentException original) {
                try {
                    return this.delegate.get((String)this.fallbackNameTransformer.apply(s));
                }
                catch (IllegalArgumentException next) {
                    original.addSuppressed(next);
                    throw original;
                }
            }
        }

        public <X> X get(int i, Class<X> aClass) {
            return (X)this.delegate.get(i, aClass);
        }

        public Object get(int i) {
            return this.delegate.get(i);
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public List<TupleElement<?>> getElements() {
            return this.delegate.getElements();
        }
    }

    static class TupleConverter
    implements Converter<Object, Object> {
        private final ReturnedType type;
        private final UnaryOperator<Tuple> tupleWrapper;

        public TupleConverter(ReturnedType type) {
            this(type, false);
        }

        public TupleConverter(ReturnedType type, boolean nativeQuery) {
            Assert.notNull((Object)type, (String)"Returned type must not be null");
            this.type = type;
            this.tupleWrapper = nativeQuery ? FallbackTupleWrapper::new : UnaryOperator.identity();
        }

        /*
         * WARNING - void declaration
         */
        public Object convert(Object source) {
            void tuple;
            if (!(source instanceof Tuple)) {
                return source;
            }
            Tuple tuple2 = (Tuple)source;
            List elements = tuple.getElements();
            if (elements.size() == 1) {
                Object value = tuple.get((TupleElement)elements.get(0));
                if (this.type.getDomainType().isInstance(value) || this.type.isInstance(value) || value == null) {
                    return value;
                }
            }
            return new TupleBackedMap((Tuple)this.tupleWrapper.apply((Tuple)tuple));
        }

        private static class TupleBackedMap
        implements Map<String, Object> {
            private static final String UNMODIFIABLE_MESSAGE = "A TupleBackedMap cannot be modified";
            private final Tuple tuple;

            TupleBackedMap(Tuple tuple) {
                this.tuple = tuple;
            }

            @Override
            public int size() {
                return this.tuple.getElements().size();
            }

            @Override
            public boolean isEmpty() {
                return this.tuple.getElements().isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                try {
                    this.tuple.get((String)key);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            @Override
            public boolean containsValue(Object value) {
                return Arrays.asList(this.tuple.toArray()).contains(value);
            }

            @Override
            @Nullable
            public Object get(Object key) {
                if (!(key instanceof String)) {
                    return null;
                }
                try {
                    return this.tuple.get((String)key);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }

            @Override
            public Object put(String key, Object value) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public void putAll(Map<? extends String, ?> m) {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
            }

            @Override
            public Set<String> keySet() {
                return this.tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toSet());
            }

            @Override
            public Collection<Object> values() {
                return Arrays.asList(this.tuple.toArray());
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this.tuple.getElements().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>(e.getAlias(), this.tuple.get(e))).collect(Collectors.toSet());
            }
        }
    }
}

