/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public final class FileUtil {
    private static final Map<String, String> fileTypes = Map.of(".json", "JSON", ".yaml", "YAML", ".xlsx", "EXCEL");

    private FileUtil() {
    }

    public static String getFileName(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (!StringUtils.hasText((String)fileName)) {
            return "";
        }
        return fileName;
    }

    public static String getFileType(MultipartFile file) {
        String fileName = FileUtil.getFileName(file);
        if (!StringUtils.hasText((String)fileName)) {
            return "";
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1 || dotIndex == fileName.length() - 1) {
            return "";
        }
        String fileNameExtension = fileName.substring(dotIndex);
        return fileTypes.get(fileNameExtension);
    }
}

