/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.DataType;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.FetchReq;
import com.taosdata.jdbc.ws.entity.FetchResp;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.RequestFactory;
import com.taosdata.jdbc.ws.entity.Response;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public abstract class AbstractWSResultSet
extends AbstractResultSet {
    protected final Statement statement;
    protected final Transport transport;
    protected final RequestFactory factory;
    protected final long queryId;
    protected volatile boolean isClosed;
    protected final ResultSetMetaData metaData;
    protected final List<RestfulResultSet.Field> fields = new ArrayList<RestfulResultSet.Field>();
    protected final List<String> columnNames;
    protected List<Integer> fieldLength;
    protected List<List<Object>> result = new ArrayList<List<Object>>();
    protected int numOfRows = 0;
    protected int rowIndex = 0;
    private boolean isCompleted;

    public AbstractWSResultSet(Statement statement, Transport transport, RequestFactory factory, QueryResp response, String database) throws SQLException {
        this.statement = statement;
        this.transport = transport;
        this.factory = factory;
        this.queryId = response.getId();
        this.columnNames = Arrays.asList(response.getFieldsNames());
        for (int i = 0; i < response.getFieldsCount(); ++i) {
            String colName = response.getFieldsNames()[i];
            int taosType = response.getFieldsTypes()[i];
            int jdbcType = DataType.convertTaosType2DataType(taosType).getJdbcTypeValue();
            int length = response.getFieldsLengths()[i];
            this.fields.add(new RestfulResultSet.Field(colName, jdbcType, length, "", taosType));
        }
        this.metaData = new RestfulResultSetMetaData(database, this.fields, null);
        this.timestampPrecision = response.getPrecision();
    }

    private boolean forward() {
        if (this.rowIndex > this.numOfRows) {
            return false;
        }
        return ++this.rowIndex < this.numOfRows;
    }

    public void reset() {
        this.rowIndex = 0;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.forward()) {
            return true;
        }
        Request request = this.factory.generateFetch(this.queryId);
        CompletableFuture<Response> send = this.transport.send(request);
        try {
            Response response = send.get();
            FetchResp fetchResp = (FetchResp)response;
            if (Code.SUCCESS.getCode() != fetchResp.getCode()) {
                throw TSDBError.createSQLException(9040, fetchResp.getMessage());
            }
            this.reset();
            if (fetchResp.isCompleted() || fetchResp.getRows() == 0) {
                this.isCompleted = true;
                return false;
            }
            this.fieldLength = Arrays.asList(fetchResp.getLengths());
            this.numOfRows = fetchResp.getRows();
            this.result = this.fetchJsonData();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            throw TSDBError.createSQLException(8984, e.getMessage());
        }
    }

    public abstract List<List<Object>> fetchJsonData() throws SQLException, ExecutionException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        AbstractWSResultSet abstractWSResultSet = this;
        synchronized (abstractWSResultSet) {
            if (!this.isClosed) {
                this.isClosed = true;
                if (this.result != null && !this.result.isEmpty() && !this.isCompleted) {
                    FetchReq fetchReq = new FetchReq(this.queryId, this.queryId);
                    this.transport.sendWithoutRep(new Request(Action.FREE_RESULT.getAction(), fetchReq));
                }
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.metaData;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }
}

