/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hugegraph.computer.core.rpc;

import java.util.Map;

import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.aggregator.RegisterAggregators;
import org.apache.hugegraph.computer.core.graph.value.Value;

public interface AggregateRpcService {

    RegisterAggregators registeredAggregators();

    Map<String, Value> listAggregators();

    void aggregateAggregators(Map<String, Value> aggregators);

    <V extends Value> Aggregator<V> getAggregator(String name);

    <V extends Value> void aggregateAggregator(String name, V value);
}
