/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.exceptions.RequestTooBigException;
import org.apache.hadoop.hbase.io.ByteBufferPool;
import org.apache.hadoop.hbase.ipc.CellBlockBuilder;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapperImpl;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class RpcServer
implements RpcServerInterface,
ConfigurationObserver {
    public static final Logger LOG = LoggerFactory.getLogger(RpcServer.class);
    protected static final CallQueueTooBigException CALL_QUEUE_TOO_BIG_EXCEPTION = new CallQueueTooBigException();
    private final boolean authorize;
    protected boolean isSecurityEnabled;
    public static final byte CURRENT_VERSION = 0;
    public static final String FALLBACK_TO_INSECURE_CLIENT_AUTH = "hbase.ipc.server.fallback-to-simple-auth-allowed";
    protected static final int DEFAULT_MAX_CALLQUEUE_LENGTH_PER_HANDLER = 10;
    protected final CellBlockBuilder cellBlockBuilder;
    protected static final String AUTH_FAILED_FOR = "Auth failed for ";
    protected static final String AUTH_SUCCESSFUL_FOR = "Auth successful for ";
    protected static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + Server.class.getName()));
    protected SecretManager<TokenIdentifier> secretManager;
    protected final Map<String, String> saslProps;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Start is synchronized so authManager creation is single-threaded")
    protected ServiceAuthorizationManager authManager;
    protected static final ThreadLocal<RpcCall> CurCall = new ThreadLocal();
    protected static final ThreadLocal<MonitoredRPCHandler> MONITORED_RPC = new ThreadLocal();
    protected final InetSocketAddress bindAddress;
    protected MetricsHBaseServer metrics;
    protected final Configuration conf;
    protected final long maxQueueSizeInBytes;
    protected static final int DEFAULT_MAX_CALLQUEUE_SIZE = 0x40000000;
    protected final LongAdder callQueueSizeInBytes = new LongAdder();
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    volatile boolean running = true;
    volatile boolean started = false;
    protected AuthenticationTokenSecretManager authTokenSecretMgr = null;
    protected HBaseRPCErrorHandler errorHandler = null;
    public static final String MAX_REQUEST_SIZE = "hbase.ipc.max.request.size";
    protected static final RequestTooBigException REQUEST_TOO_BIG_EXCEPTION = new RequestTooBigException();
    protected static final String WARN_RESPONSE_TIME = "hbase.ipc.warn.response.time";
    protected static final String WARN_RESPONSE_SIZE = "hbase.ipc.warn.response.size";
    protected static final String MIN_CLIENT_REQUEST_TIMEOUT = "hbase.ipc.min.client.request.timeout";
    protected static final int DEFAULT_MIN_CLIENT_REQUEST_TIMEOUT = 20;
    public static final int DEFAULT_MAX_REQUEST_SIZE = 0x10000000;
    protected static final int DEFAULT_WARN_RESPONSE_TIME = 10000;
    protected static final int DEFAULT_WARN_RESPONSE_SIZE = 0x6400000;
    protected static final int DEFAULT_TRACE_LOG_MAX_LENGTH = 1000;
    protected static final String TRACE_LOG_MAX_LENGTH = "hbase.ipc.trace.log.max.length";
    protected static final String KEY_WORD_TRUNCATED = " <TRUNCATED>";
    protected static final Gson GSON = GsonUtil.createGson().create();
    protected final int maxRequestSize;
    protected final int warnResponseTime;
    protected final int warnResponseSize;
    protected final int minClientRequestTimeout;
    protected final Server server;
    protected final List<BlockingServiceAndInterface> services;
    protected final RpcScheduler scheduler;
    protected UserProvider userProvider;
    protected final ByteBufferPool reservoir;
    protected final int minSizeForReservoirUse;
    protected volatile boolean allowFallbackToSimpleAuth;
    private RSRpcServices rsRpcServices;
    protected static final int NIO_BUFFER_LIMIT = 65536;

    public RpcServer(Server server, String name, List<BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler, boolean reservoirEnabled) throws IOException {
        if (reservoirEnabled) {
            int poolBufSize = conf.getInt("hbase.ipc.server.reservoir.initial.buffer.size", 65536);
            int bufsForTwoMB = 0x200000 / poolBufSize;
            int maxPoolSize = conf.getInt("hbase.ipc.server.reservoir.initial.max", conf.getInt("hbase.regionserver.handler.count", 30) * bufsForTwoMB * 2);
            this.reservoir = new ByteBufferPool(poolBufSize, maxPoolSize);
            this.minSizeForReservoirUse = RpcServer.getMinSizeForReservoirUse(this.reservoir);
        } else {
            this.reservoir = null;
            this.minSizeForReservoirUse = Integer.MAX_VALUE;
        }
        this.server = server;
        this.services = services;
        this.bindAddress = bindAddress;
        this.conf = conf;
        this.maxQueueSizeInBytes = this.conf.getLong("hbase.ipc.server.max.callqueue.size", 0x40000000L);
        this.warnResponseTime = conf.getInt(WARN_RESPONSE_TIME, 10000);
        this.warnResponseSize = conf.getInt(WARN_RESPONSE_SIZE, 0x6400000);
        this.minClientRequestTimeout = conf.getInt(MIN_CLIENT_REQUEST_TIMEOUT, 20);
        this.maxRequestSize = conf.getInt(MAX_REQUEST_SIZE, 0x10000000);
        this.metrics = new MetricsHBaseServer(name, new MetricsHBaseServerWrapperImpl(this));
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.server.tcpnodelay", true);
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.server.tcpkeepalive", true);
        this.cellBlockBuilder = new CellBlockBuilder(conf);
        this.authorize = conf.getBoolean("hadoop.security.authorization", false);
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        this.isSecurityEnabled = this.userProvider.isHBaseSecurityEnabled();
        this.saslProps = this.isSecurityEnabled ? SaslUtil.initSaslProperties((String)conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase(Locale.ROOT))) : Collections.emptyMap();
        this.scheduler = scheduler;
    }

    @VisibleForTesting
    static int getMinSizeForReservoirUse(ByteBufferPool pool) {
        return pool.getBufferSize() / 6;
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        this.initReconfigurable(newConf);
        if (this.scheduler instanceof ConfigurationObserver) {
            ((ConfigurationObserver)((Object)this.scheduler)).onConfigurationChange(newConf);
        }
    }

    protected void initReconfigurable(Configuration confToLoad) {
        this.allowFallbackToSimpleAuth = confToLoad.getBoolean(FALLBACK_TO_INSECURE_CLIENT_AUTH, false);
        if (this.isSecurityEnabled && this.allowFallbackToSimpleAuth) {
            LOG.warn("********* WARNING! *********");
            LOG.warn("This server is configured to allow connections from INSECURE clients");
            LOG.warn("(hbase.ipc.server.fallback-to-simple-auth-allowed = true).");
            LOG.warn("While this option is enabled, client identities cannot be secured, and user");
            LOG.warn("impersonation is possible!");
            LOG.warn("For secure operation, please disable SIMPLE authentication as soon as possible,");
            LOG.warn("by setting hbase.ipc.server.fallback-to-simple-auth-allowed = false in hbase-site.xml");
            LOG.warn("****************************");
        }
    }

    Configuration getConf() {
        return this.conf;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAuthManager(PolicyProvider pp) {
        ServiceAuthorizationManager serviceAuthorizationManager = this.authManager;
        synchronized (serviceAuthorizationManager) {
            this.authManager.refresh(this.conf, pp);
        }
    }

    protected AuthenticationTokenSecretManager createSecretManager() {
        if (!this.isSecurityEnabled) {
            return null;
        }
        if (this.server == null) {
            return null;
        }
        Configuration conf = this.server.getConfiguration();
        long keyUpdateInterval = conf.getLong("hbase.auth.key.update.interval", 86400000L);
        long maxAge = conf.getLong("hbase.auth.token.max.lifetime", 604800000L);
        return new AuthenticationTokenSecretManager(conf, this.server.getZooKeeper(), this.server.getServerName().toString(), keyUpdateInterval, maxAge);
    }

    public SecretManager<? extends TokenIdentifier> getSecretManager() {
        return this.secretManager;
    }

    public void setSecretManager(SecretManager<? extends TokenIdentifier> secretManager) {
        this.secretManager = secretManager;
    }

    @Override
    public Pair<Message, CellScanner> call(RpcCall call, MonitoredRPCHandler status) throws IOException {
        try {
            boolean tooLarge;
            Descriptors.MethodDescriptor md = call.getMethod();
            Message param = call.getParam();
            status.setRPC(md.getName(), new Object[]{param}, call.getReceiveTime());
            status.setRPCPacket(param);
            status.resume("Servicing call");
            HBaseRpcControllerImpl controller = new HBaseRpcControllerImpl(call.getCellScanner());
            controller.setCallTimeout(call.getTimeout());
            Message result = call.getService().callBlockingMethod(md, (RpcController)controller, param);
            long receiveTime = call.getReceiveTime();
            long startTime = call.getStartTime();
            long endTime = System.currentTimeMillis();
            int processingTime = (int)(endTime - startTime);
            int qTime = (int)(startTime - receiveTime);
            int totalTime = (int)(endTime - receiveTime);
            if (LOG.isTraceEnabled()) {
                LOG.trace(CurCall.get().toString() + ", response " + TextFormat.shortDebugString((MessageOrBuilder)result) + " queueTime: " + qTime + " processingTime: " + processingTime + " totalTime: " + totalTime);
            }
            long requestSize = call.getSize();
            long responseSize = result.getSerializedSize();
            if (call.isClientCellBlockSupported()) {
                responseSize += call.getResponseCellSize();
            }
            this.metrics.dequeuedCall(qTime);
            this.metrics.processedCall(processingTime);
            this.metrics.totalCall(totalTime);
            this.metrics.receivedRequest(requestSize);
            this.metrics.sentResponse(responseSize);
            boolean tooSlow = processingTime > this.warnResponseTime && this.warnResponseTime > -1;
            boolean bl = tooLarge = responseSize > (long)this.warnResponseSize && this.warnResponseSize > -1;
            if (tooSlow || tooLarge) {
                this.logResponse(param, md.getName(), md.getName() + "(" + param.getClass().getName() + ")", tooLarge ? "TooLarge" : "TooSlow", status.getClient(), startTime, processingTime, qTime, responseSize);
            }
            return new Pair((Object)result, (Object)controller.cellScanner());
        }
        catch (Throwable e) {
            if (e instanceof ServiceException) {
                if (e.getCause() == null) {
                    LOG.debug("Caught a ServiceException with null cause", e);
                } else {
                    e = e.getCause();
                }
            }
            this.metrics.exception(e);
            if (e instanceof LinkageError) {
                throw new DoNotRetryIOException(e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            LOG.error("Unexpected throwable object ", e);
            throw new IOException(e.getMessage(), e);
        }
    }

    void logResponse(Message param, String methodName, String call, String tag, String clientAddress, long startTime, int processingTime, int qTime, long responseSize) throws IOException {
        long scannerId;
        String scanDetails;
        ClientProtos.ScanRequest request;
        HashMap<String, Object> responseInfo = new HashMap<String, Object>();
        responseInfo.put("starttimems", startTime);
        responseInfo.put("processingtimems", processingTime);
        responseInfo.put("queuetimems", qTime);
        responseInfo.put("responsesize", responseSize);
        responseInfo.put("client", clientAddress);
        responseInfo.put("class", this.server == null ? "" : this.server.getClass().getSimpleName());
        responseInfo.put("method", methodName);
        responseInfo.put("call", call);
        String stringifiedParam = ProtobufUtil.getShortTextFormat((Message)param);
        if (stringifiedParam.length() > 150) {
            stringifiedParam = this.truncateTraceLog(stringifiedParam);
        }
        responseInfo.put("param", stringifiedParam);
        if (param instanceof ClientProtos.ScanRequest && this.rsRpcServices != null && (request = (ClientProtos.ScanRequest)param).hasScannerId() && (scanDetails = this.rsRpcServices.getScanDetailsWithId(scannerId = request.getScannerId())) != null) {
            responseInfo.put("scandetails", scanDetails);
        }
        if (param instanceof ClientProtos.MultiRequest) {
            int numGets = 0;
            int numMutations = 0;
            int numServiceCalls = 0;
            ClientProtos.MultiRequest multi = (ClientProtos.MultiRequest)param;
            for (ClientProtos.RegionAction regionAction : multi.getRegionActionList()) {
                for (ClientProtos.Action action : regionAction.getActionList()) {
                    if (action.hasMutation()) {
                        ++numMutations;
                    }
                    if (action.hasGet()) {
                        ++numGets;
                    }
                    if (!action.hasServiceCall()) continue;
                    ++numServiceCalls;
                }
            }
            responseInfo.put("multi.gets", numGets);
            responseInfo.put("multi.mutations", numMutations);
            responseInfo.put("multi.servicecalls", numServiceCalls);
        }
        LOG.warn("(response" + tag + "): " + GSON.toJson(responseInfo));
    }

    @VisibleForTesting
    String truncateTraceLog(String strParam) {
        if (LOG.isTraceEnabled()) {
            int traceLogMaxLength = this.getConf().getInt(TRACE_LOG_MAX_LENGTH, 1000);
            int truncatedLength = strParam.length() < traceLogMaxLength ? strParam.length() : traceLogMaxLength;
            String truncatedFlag = truncatedLength == strParam.length() ? "" : KEY_WORD_TRUNCATED;
            return strParam.subSequence(0, truncatedLength) + truncatedFlag;
        }
        return strParam.subSequence(0, 150) + KEY_WORD_TRUNCATED;
    }

    @Override
    public void setErrorHandler(HBaseRPCErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public HBaseRPCErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public MetricsHBaseServer getMetrics() {
        return this.metrics;
    }

    @Override
    public void addCallSize(long diff) {
        this.callQueueSizeInBytes.add(diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authorize(UserGroupInformation user, RPCProtos.ConnectionHeader connection, InetAddress addr) throws AuthorizationException {
        if (this.authorize) {
            Class<?> c = RpcServer.getServiceInterface(this.services, connection.getServiceName());
            ServiceAuthorizationManager serviceAuthorizationManager = this.authManager;
            synchronized (serviceAuthorizationManager) {
                this.authManager.authorize(user, c, this.getConf(), addr);
            }
        }
    }

    protected int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int count;
        int n = count = buffer.remaining() <= 65536 ? channel.read(buffer) : RpcServer.channelIO(channel, null, buffer);
        if (count > 0) {
            this.metrics.receivedBytes(count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), 65536);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    @VisibleForTesting
    static Pair<ByteBuff, CallCleanup> allocateByteBuffToReadInto(ByteBufferPool pool, int minSizeForPoolUse, int reqLen) {
        SingleByteBuff resultBuf;
        int remain;
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(reqLen / pool.getBufferSize() + 1);
        ByteBuffer buf = null;
        for (remain = reqLen; remain >= minSizeForPoolUse && (buf = pool.getBuffer()) != null; remain -= pool.getBufferSize()) {
            bbs.add(buf);
        }
        ByteBuffer[] bufsFromPool = null;
        if (bbs.size() > 0) {
            bufsFromPool = new ByteBuffer[bbs.size()];
            bbs.toArray(bufsFromPool);
        }
        if (remain > 0) {
            bbs.add(ByteBuffer.allocate(remain));
        }
        if (bbs.size() > 1) {
            ByteBuffer[] items = new ByteBuffer[bbs.size()];
            bbs.toArray(items);
            resultBuf = new MultiByteBuff(items);
        } else {
            resultBuf = new SingleByteBuff((ByteBuffer)bbs.get(0));
        }
        resultBuf.limit(reqLen);
        if (bufsFromPool != null) {
            ByteBuffer[] bufsFromPoolFinal = bufsFromPool;
            return new Pair((Object)resultBuf, () -> {
                for (int i = 0; i < bufsFromPoolFinal.length; ++i) {
                    pool.putbackBuffer(bufsFromPoolFinal[i]);
                }
            });
        }
        return new Pair((Object)resultBuf, null);
    }

    public static Optional<RpcCall> getCurrentCall() {
        return Optional.ofNullable(CurCall.get());
    }

    public static boolean isInRpcCallContext() {
        return CurCall.get() != null;
    }

    public static Optional<User> getRequestUser() {
        Optional<RpcCall> ctx = RpcServer.getCurrentCall();
        return ctx.isPresent() ? ctx.get().getRequestUser() : Optional.empty();
    }

    public abstract int getNumOpenConnections();

    public static Optional<String> getRequestUserName() {
        return RpcServer.getRequestUser().map(User::getShortName);
    }

    public static Optional<InetAddress> getRemoteAddress() {
        return RpcServer.getCurrentCall().map(RpcCallContext::getRemoteAddress);
    }

    protected static BlockingServiceAndInterface getServiceAndInterface(List<BlockingServiceAndInterface> services, String serviceName) {
        for (BlockingServiceAndInterface bs : services) {
            if (!bs.getBlockingService().getDescriptorForType().getName().equals(serviceName)) continue;
            return bs;
        }
        return null;
    }

    protected static Class<?> getServiceInterface(List<BlockingServiceAndInterface> services, String serviceName) {
        BlockingServiceAndInterface bsasi = RpcServer.getServiceAndInterface(services, serviceName);
        return bsasi == null ? null : bsasi.getServiceInterface();
    }

    protected static BlockingService getService(List<BlockingServiceAndInterface> services, String serviceName) {
        BlockingServiceAndInterface bsasi = RpcServer.getServiceAndInterface(services, serviceName);
        return bsasi == null ? null : bsasi.getBlockingService();
    }

    protected static MonitoredRPCHandler getStatus() {
        MonitoredRPCHandler status = MONITORED_RPC.get();
        if (status != null) {
            return status;
        }
        status = TaskMonitor.get().createRPCStatus(Thread.currentThread().getName());
        status.pause("Waiting for a call");
        MONITORED_RPC.set(status);
        return status;
    }

    public static InetAddress getRemoteIp() {
        RpcCall call = CurCall.get();
        if (call != null) {
            return call.getRemoteAddress();
        }
        return null;
    }

    @Override
    public RpcScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setRsRpcServices(RSRpcServices rsRpcServices) {
        this.rsRpcServices = rsRpcServices;
    }

    public static class BlockingServiceAndInterface {
        private final BlockingService service;
        private final Class<?> serviceInterface;

        public BlockingServiceAndInterface(BlockingService service, Class<?> serviceInterface) {
            this.service = service;
            this.serviceInterface = serviceInterface;
        }

        public Class<?> getServiceInterface() {
            return this.serviceInterface;
        }

        public BlockingService getBlockingService() {
            return this.service;
        }
    }

    @FunctionalInterface
    protected static interface CallCleanup {
        public void run();
    }
}

