/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class SelectColumnIsFalse
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;

    public SelectColumnIsFalse(int colNum1) {
        this.colNum1 = colNum1;
    }

    public SelectColumnIsFalse() {
        this.colNum1 = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        boolean[] nullVector = inputColVector1.isNull;
        if (n <= 0) {
            return;
        }
        if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating) {
                if (vector1[0] != 1L) return;
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] != 0L) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
                return;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] != 0L) continue;
                    sel[newSize++] = i;
                }
                if (newSize >= n) return;
                batch.selectedInUse = true;
                batch.size = newSize;
            }
            return;
        } else if (inputColVector1.isRepeating) {
            if (!nullVector[0] && vector1[0] != 1L) return;
            batch.size = 0;
            return;
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (vector1[i] != 0L || nullVector[i]) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
            return;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (vector1[i] != 0L || nullVector[i]) continue;
                sel[newSize++] = i;
            }
            if (newSize >= n) return;
            batch.selectedInUse = true;
            batch.size = newSize;
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

