/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandUtil {
    public static final Logger LOG = LoggerFactory.getLogger(CommandUtil.class);

    CommandUtil() {
    }

    static CommandProcessorResponse authorizeCommand(SessionState ss, HiveOperationType type, List<String> command) {
        if (ss == null) {
            return null;
        }
        if (ss.isAuthorizationModeV2() && HiveConf.getBoolVar(ss.getConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            String errMsg = "Error authorizing command " + command;
            try {
                CommandUtil.authorizeCommandThrowEx(ss, type, command);
                return null;
            }
            catch (HiveAuthzPluginException e) {
                LOG.error(errMsg, (Throwable)e);
                return CommandProcessorResponse.create(e);
            }
            catch (HiveAccessControlException e) {
                LOG.error(errMsg, (Throwable)e);
                return CommandProcessorResponse.create(e);
            }
        }
        return null;
    }

    static void authorizeCommandThrowEx(SessionState ss, HiveOperationType type, List<String> command) throws HiveAuthzPluginException, HiveAccessControlException {
        HivePrivilegeObject commandObj = HivePrivilegeObject.createHivePrivilegeObject(command);
        HiveAuthzContext.Builder ctxBuilder = new HiveAuthzContext.Builder();
        ctxBuilder.setCommandString(Joiner.on(' ').join(command));
        ctxBuilder.setUserIpAddress(ss.getUserIpAddress());
        ctxBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        ss.getAuthorizerV2().checkPrivileges(type, Arrays.asList(commandObj), null, ctxBuilder.build());
    }

    static CommandProcessorResponse authorizeCommandAndServiceObject(SessionState ss, HiveOperationType type, List<String> command, String serviceObject) {
        if (ss == null) {
            return null;
        }
        if (ss.isAuthorizationModeV2() && HiveConf.getBoolVar(ss.getConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            String errMsg = "Error authorizing command " + command;
            try {
                CommandUtil.authorizeCommandThrowEx(ss, type, command, serviceObject);
                return null;
            }
            catch (HiveAccessControlException | HiveAuthzPluginException e) {
                LOG.error(errMsg, (Throwable)e);
                return CommandProcessorResponse.create(e);
            }
        }
        return null;
    }

    private static void authorizeCommandThrowEx(SessionState ss, HiveOperationType type, List<String> command, String serviceObject) throws HiveAuthzPluginException, HiveAccessControlException {
        HivePrivilegeObject commandObj = HivePrivilegeObject.createHivePrivilegeObject(command);
        HivePrivilegeObject serviceObj = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.SERVICE_NAME, null, serviceObject, null, null, null);
        HiveAuthzContext.Builder ctxBuilder = new HiveAuthzContext.Builder();
        ctxBuilder.setCommandString(Joiner.on(' ').join(command));
        ctxBuilder.setUserIpAddress(ss.getUserIpAddress());
        ctxBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        ss.getAuthorizerV2().checkPrivileges(type, Collections.singletonList(commandObj), Collections.singletonList(serviceObj), ctxBuilder.build());
    }
}

