/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import org.apache.hadoop.hive.ql.wm.CounterLimit;

public class FileSystemCounterLimit
implements CounterLimit {
    private String scheme;
    private FSCounter fsCounter;
    private long limit;

    FileSystemCounterLimit(String scheme, FSCounter fsCounter, long limit) {
        this.scheme = scheme == null || scheme.isEmpty() ? "" : scheme.toUpperCase();
        this.fsCounter = fsCounter;
        this.limit = limit;
    }

    static FileSystemCounterLimit fromName(String counterName, long limit) {
        String counterNameStr = counterName.toUpperCase();
        for (FSCounter fsCounter : FSCounter.values()) {
            if (!counterNameStr.endsWith(fsCounter.name())) continue;
            int startIdx = counterNameStr.indexOf(fsCounter.name());
            if (startIdx == 0) {
                return new FileSystemCounterLimit(null, FSCounter.valueOf(counterName), limit);
            }
            String scheme = counterNameStr.substring(0, startIdx - 1);
            return new FileSystemCounterLimit(scheme, FSCounter.valueOf(fsCounter.name()), limit);
        }
        throw new IllegalArgumentException("Invalid counter name specified " + counterName.toUpperCase() + "");
    }

    @Override
    public String getName() {
        return this.scheme.isEmpty() ? this.fsCounter.name() : this.scheme.toUpperCase() + "_" + this.fsCounter.name();
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public CounterLimit clone() {
        return new FileSystemCounterLimit(this.scheme, this.fsCounter, this.limit);
    }

    public String toString() {
        return "counter: " + this.getName() + " limit: " + this.limit;
    }

    public int hashCode() {
        int hash = 31 * this.scheme.hashCode();
        hash += 31 * this.fsCounter.hashCode();
        hash = (int)((long)hash + 31L * this.limit);
        return 31 * hash;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof FileSystemCounterLimit)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        FileSystemCounterLimit otherFscl = (FileSystemCounterLimit)other;
        return this.scheme.equals(otherFscl.scheme) && this.fsCounter.equals((Object)otherFscl.fsCounter) && this.limit == otherFscl.limit;
    }

    public static enum FSCounter {
        BYTES_READ,
        BYTES_WRITTEN,
        SHUFFLE_BYTES;

    }
}

