/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.event;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.event.Event;
import org.apache.hugegraph.event.EventListener;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class EventHub {
    private static final Logger LOG = Log.logger(EventHub.class);
    public static final String EVENT_WORKER = "event-worker-%d";
    public static final String ANY_EVENT = "*";
    private static final List<EventListener> EMPTY = ImmutableList.of();
    private static ExecutorService executor = null;
    private String name;
    private Map<String, List<EventListener>> listeners;

    public EventHub() {
        this("hub");
    }

    public EventHub(String name) {
        this(name, 1);
    }

    public EventHub(String name, int threadSize) {
        LOG.debug("Create new EventHub {}", (Object)name);
        this.name = name;
        this.listeners = new ConcurrentHashMap<String, List<EventListener>>();
        EventHub.init(threadSize);
    }

    public static synchronized void init(int poolSize) {
        if (executor != null) {
            return;
        }
        LOG.debug("Init pool(size {}) for EventHub", (Object)poolSize);
        executor = ExecutorUtil.newFixedThreadPool(poolSize, EVENT_WORKER);
    }

    public static synchronized boolean destroy(long timeout) throws InterruptedException {
        E.checkState(executor != null, "EventHub has not been initialized", new Object[0]);
        LOG.debug("Destroy pool for EventHub");
        executor.shutdown();
        return executor.awaitTermination(timeout, TimeUnit.SECONDS);
    }

    private static ExecutorService executor() {
        ExecutorService e = executor;
        E.checkState(e != null, "The event executor has been destroyed", new Object[0]);
        return e;
    }

    public String name() {
        return this.name;
    }

    public boolean containsListener(String event) {
        List<EventListener> ls = this.listeners.get(event);
        return ls != null && ls.size() > 0;
    }

    public List<EventListener> listeners(String event) {
        List<EventListener> ls = this.listeners.get(event);
        return ls == null ? EMPTY : Collections.unmodifiableList(ls);
    }

    public void listen(String event, EventListener listener) {
        E.checkNotNull(event, "event");
        E.checkNotNull(listener, "event listener");
        if (!this.listeners.containsKey(event)) {
            this.listeners.putIfAbsent(event, new CopyOnWriteArrayList());
        }
        List<EventListener> ls = this.listeners.get(event);
        assert (ls != null) : this.listeners;
        ls.add(listener);
    }

    public List<EventListener> unlisten(String event) {
        List<EventListener> ls = this.listeners.remove(event);
        return ls == null ? EMPTY : Collections.unmodifiableList(ls);
    }

    public int unlisten(String event, EventListener listener) {
        List<EventListener> ls = this.listeners.get(event);
        if (ls == null) {
            return 0;
        }
        int count = 0;
        while (ls.remove(listener)) {
            ++count;
        }
        return count;
    }

    public Future<Integer> notify(String event, Object ... args) {
        List<EventListener> lsAny;
        ExtendableIterator<EventListener> all = new ExtendableIterator<EventListener>();
        List<EventListener> ls = this.listeners.get(event);
        if (ls != null && !ls.isEmpty()) {
            all.extend(ls.iterator());
        }
        if ((lsAny = this.listeners.get(ANY_EVENT)) != null && !lsAny.isEmpty()) {
            all.extend(lsAny.iterator());
        }
        if (!all.hasNext()) {
            return CompletableFuture.completedFuture(0);
        }
        Event ev = new Event(this, event, args);
        return EventHub.executor().submit(() -> {
            int count = 0;
            while (all.hasNext()) {
                try {
                    ((EventListener)all.next()).event(ev);
                    ++count;
                }
                catch (Throwable e) {
                    LOG.warn("Failed to handle event: {}", (Object)ev, (Object)e);
                }
            }
            return count;
        });
    }

    public Object call(String event, Object ... args) {
        List<EventListener> ls = this.listeners.get(event);
        if (ls == null) {
            throw new RuntimeException("Not found listener for: " + event);
        }
        if (ls.size() != 1) {
            throw new RuntimeException("Too many listeners for: " + event);
        }
        EventListener listener = ls.get(0);
        return listener.event(new Event(this, event, args));
    }
}

