/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class SecurityHeadersFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHeadersFilter.class);
    private static final String DEFAULT_HSTS = "";
    private static final String DEFAULT_CSP = "";
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        LOG.info("Added security headers filter");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String csp;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addHeader("X-Content-Type-Options", "nosniff");
        httpResponse.addHeader("X-XSS-Protection", "1; mode=block");
        String hsts = this.filterConfig.getInitParameter("hsts");
        if (StringUtils.isNotBlank((CharSequence)hsts)) {
            httpResponse.addHeader("Strict-Transport-Security", hsts);
        }
        if (StringUtils.isNotBlank((CharSequence)(csp = this.filterConfig.getInitParameter("csp")))) {
            httpResponse.addHeader("Content-Security-Policy", csp);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static Map<String, String> getDefaultParameters(Configuration conf) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hsts", conf.get("hbase.http.filter.hsts.value", ""));
        params.put("csp", conf.get("hbase.http.filter.csp.value", ""));
        return params;
    }
}

