/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.task;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import org.apache.hugegraph.controller.BaseController;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.service.algorithm.AsyncTaskService;
import org.apache.hugegraph.structure.Task;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/async-tasks"})
public class AsyncTaskController
extends BaseController {
    private static final Logger log = LogManager.getLogger(AsyncTaskController.class);
    private final AsyncTaskService service;

    @Autowired
    public AsyncTaskController(AsyncTaskService service) {
        this.service = service;
    }

    @GetMapping(value={"{id}"})
    public Task get(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id) {
        Task task = this.service.get(connId, id);
        if (task == null) {
            throw new ExternalException("async.task.not-exist.id", id);
        }
        return task;
    }

    @PostMapping(value={"cancel/{id}"})
    public Task cancel(@PathVariable(value="connId") int connId, @PathVariable(value="id") int id) {
        Task task = this.service.cancel(connId, id);
        if (task == null) {
            throw new ExternalException("async.task.not-exist.id", id);
        }
        return task;
    }

    @GetMapping(value={"ids"})
    public List<Task> list(@PathVariable(value="connId") int connId, @RequestParam(value="ids") List<Long> taskIds) {
        return this.service.list(connId, taskIds);
    }

    @GetMapping
    public IPage<Task> list(@PathVariable(value="connId") int connId, @RequestParam(name="page_no", required=false, defaultValue="1") int pageNo, @RequestParam(name="page_size", required=false, defaultValue="10") int pageSize, @RequestParam(name="content", required=false, defaultValue="") String content, @RequestParam(name="type", required=false, defaultValue="") String type, @RequestParam(name="status", required=false, defaultValue="") String status) {
        return this.service.list(connId, pageNo, pageSize, content, type, status);
    }

    @DeleteMapping
    public void delete(@PathVariable(value="connId") int connId, @RequestParam(value="ids") List<Integer> ids) {
        for (int id : ids) {
            Task task = this.service.get(connId, id);
            if (task == null) {
                throw new ExternalException("async.task.not-exist.id", id);
            }
            this.service.remove(connId, id);
        }
    }
}

