/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultBoundedCompletionService;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RpcRetryingCallerWithReadReplicas {
    private static final Logger LOG = LoggerFactory.getLogger(RpcRetryingCallerWithReadReplicas.class);
    protected final ExecutorService pool;
    protected final ClusterConnection cConnection;
    protected final Configuration conf;
    protected final Get get;
    protected final TableName tableName;
    protected final int timeBeforeReplicas;
    private final int operationTimeout;
    private final int rpcTimeout;
    private final int retries;
    private final RpcControllerFactory rpcControllerFactory;
    private final RpcRetryingCallerFactory rpcRetryingCallerFactory;

    public RpcRetryingCallerWithReadReplicas(RpcControllerFactory rpcControllerFactory, TableName tableName, ClusterConnection cConnection, Get get, ExecutorService pool, int retries, int operationTimeout, int rpcTimeout, int timeBeforeReplicas) {
        this.rpcControllerFactory = rpcControllerFactory;
        this.tableName = tableName;
        this.cConnection = cConnection;
        this.conf = cConnection.getConfiguration();
        this.get = get;
        this.pool = pool;
        this.retries = retries;
        this.operationTimeout = operationTimeout;
        this.rpcTimeout = rpcTimeout;
        this.timeBeforeReplicas = timeBeforeReplicas;
        this.rpcRetryingCallerFactory = new RpcRetryingCallerFactory(this.conf);
    }

    /*
     * Unable to fully structure code
     */
    public Result call(int operationTimeout) throws DoNotRetryIOException, InterruptedIOException, RetriesExhaustedException {
        isTargetReplicaSpecified = this.get.getReplicaId() >= 0;
        rl = null;
        skipPrimary = false;
        try {
            rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(true, isTargetReplicaSpecified != false ? this.get.getReplicaId() : 0, this.cConnection, this.tableName, this.get.getRow());
        }
        catch (DoNotRetryIOException | RetriesExhaustedException e) {
            if (isTargetReplicaSpecified) {
                throw e;
            }
            if (this.cConnection instanceof ConnectionImplementation) {
                rl = ((ConnectionImplementation)this.cConnection).getCachedLocation(this.tableName, this.get.getRow());
                if (rl == null) {
                    throw e;
                }
                skipPrimary = true;
            }
            throw e;
        }
        cs = new ResultBoundedCompletionService<Result>(this.rpcRetryingCallerFactory, this.pool, rl.size());
        startIndex = 0;
        endIndex = rl.size();
        if (isTargetReplicaSpecified) {
            this.addCallsForReplica(cs, rl, this.get.getReplicaId(), this.get.getReplicaId());
            endIndex = 1;
        } else {
            if (!skipPrimary) {
                this.addCallsForReplica(cs, rl, 0, 0);
                try {
                    f = cs.poll(this.timeBeforeReplicas, TimeUnit.MICROSECONDS);
                    if (f != null) {
                        return (Result)f.get();
                    }
                    if (this.cConnection.getConnectionMetrics() == null) ** GOTO lbl43
                    this.cConnection.getConnectionMetrics().incrHedgedReadOps();
                }
                catch (ExecutionException e) {
                    if (RpcRetryingCallerWithReadReplicas.LOG.isDebugEnabled()) {
                        RpcRetryingCallerWithReadReplicas.LOG.debug("Primary replica returns " + e.getCause());
                    }
                    startIndex = 1;
                }
                catch (CancellationException e) {
                    throw new InterruptedIOException();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } else {
                --endIndex;
            }
lbl43:
            // 4 sources

            this.addCallsForReplica(cs, rl, 1, rl.size() - 1);
        }
        try {
            f = cs.pollForFirstSuccessfullyCompletedTask(operationTimeout, TimeUnit.MILLISECONDS, startIndex, endIndex);
            if (f == null) {
                throw new RetriesExhaustedException("Timed out after " + operationTimeout + "ms. Get is sent to replicas with startIndex: " + startIndex + ", endIndex: " + endIndex + ", Locations: " + rl);
            }
            if (this.cConnection.getConnectionMetrics() != null && !isTargetReplicaSpecified && !skipPrimary && f.getReplicaId() != 0) {
                this.cConnection.getConnectionMetrics().incrHedgedReadWin();
            }
            var9_16 = f.get();
            return var9_16;
        }
        catch (ExecutionException e) {
            RpcRetryingCallerWithReadReplicas.throwEnrichedException(e, this.retries);
        }
        catch (CancellationException e) {
            throw new InterruptedIOException();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            cs.cancelAll();
        }
        RpcRetryingCallerWithReadReplicas.LOG.error("Imposible? Arrive at an unreachable line...");
        return null;
    }

    static void throwEnrichedException(ExecutionException e, int retries) throws RetriesExhaustedException, DoNotRetryIOException {
        Throwable t = e.getCause();
        assert (t != null);
        t.printStackTrace();
        if (t instanceof RetriesExhaustedException) {
            throw (RetriesExhaustedException)t;
        }
        if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)((Object)t);
        }
        RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, EnvironmentEdgeManager.currentTime(), null);
        List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = Collections.singletonList(qt);
        throw new RetriesExhaustedException(retries, exceptions);
    }

    private void addCallsForReplica(ResultBoundedCompletionService<Result> cs, RegionLocations rl, int min, int max) {
        for (int id = min; id <= max; ++id) {
            HRegionLocation hrl = rl.getRegionLocation(id);
            ReplicaRegionServerCallable callOnReplica = new ReplicaRegionServerCallable(id, hrl);
            cs.submit(callOnReplica, this.operationTimeout, id);
        }
    }

    static RegionLocations getRegionLocations(boolean useCache, int replicaId, ClusterConnection cConnection, TableName tableName, byte[] row) throws RetriesExhaustedException, DoNotRetryIOException, InterruptedIOException {
        RegionLocations rl;
        try {
            rl = useCache ? cConnection.locateRegion(tableName, row, true, true, replicaId) : cConnection.relocateRegion(tableName, row, replicaId);
        }
        catch (InterruptedIOException | DoNotRetryIOException | RetriesExhaustedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RetriesExhaustedException("Can't get the location for replica " + replicaId, e);
        }
        if (rl == null) {
            throw new RetriesExhaustedException("Can't get the location for replica " + replicaId);
        }
        return rl;
    }

    class ReplicaRegionServerCallable
    extends CancellableRegionServerCallable<Result> {
        final int id;

        public ReplicaRegionServerCallable(int id, HRegionLocation location) {
            super(RpcRetryingCallerWithReadReplicas.this.cConnection, RpcRetryingCallerWithReadReplicas.this.tableName, RpcRetryingCallerWithReadReplicas.this.get.getRow(), RpcRetryingCallerWithReadReplicas.this.rpcControllerFactory.newController(), RpcRetryingCallerWithReadReplicas.this.rpcTimeout, new RetryingTimeTracker(), -1);
            this.id = id;
            this.location = location;
        }

        @Override
        public void prepare(boolean reload) throws IOException {
            if (this.getRpcController().isCanceled()) {
                return;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (reload || this.location == null) {
                RegionLocations rl = RpcRetryingCallerWithReadReplicas.getRegionLocations(false, this.id, RpcRetryingCallerWithReadReplicas.this.cConnection, RpcRetryingCallerWithReadReplicas.this.tableName, RpcRetryingCallerWithReadReplicas.this.get.getRow());
                HRegionLocation hRegionLocation = this.location = this.id < rl.size() ? rl.getRegionLocation(this.id) : null;
            }
            if (this.location == null || this.location.getServerName() == null) {
                throw new HBaseIOException("There is no location for replica id #" + this.id);
            }
            this.setStubByServiceName(this.location.getServerName());
        }

        @Override
        protected Result rpcCall() throws Exception {
            if (this.getRpcController().isCanceled()) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            byte[] reg = this.location.getRegionInfo().getRegionName();
            ClientProtos.GetRequest request = RequestConverter.buildGetRequest(reg, RpcRetryingCallerWithReadReplicas.this.get);
            HBaseRpcController hrc = (HBaseRpcController)this.getRpcController();
            hrc.reset();
            hrc.setCallTimeout(RpcRetryingCallerWithReadReplicas.this.rpcTimeout);
            hrc.setPriority(RpcRetryingCallerWithReadReplicas.this.tableName);
            ClientProtos.GetResponse response = ((ClientProtos.ClientService.BlockingInterface)this.getStub()).get((RpcController)hrc, request);
            if (response == null) {
                return null;
            }
            return ProtobufUtil.toResult(response.getResult(), hrc.cellScanner());
        }
    }
}

