/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.hugegraph.util.E;

public final class VersionUtil {
    public static boolean match(Version version, String begin, String end) {
        E.checkArgumentNotNull(version, "The version to match is null", new Object[0]);
        return version.compareTo(new Version(begin)) >= 0 && version.compareTo(new Version(end)) < 0;
    }

    public static boolean gte(String version, String other) {
        E.checkArgumentNotNull(version, "The version to match is null", new Object[0]);
        return new Version(version).compareTo(new Version(other)) >= 0;
    }

    public static void check(Version version, String begin, String end, String component) {
        E.checkState(VersionUtil.match(version, begin, end), "The version %s of '%s' is not in [%s, %s)", version, component, begin, end);
    }

    public static String getImplementationVersion(Class<?> clazz) {
        String className = clazz.getSimpleName() + ".class";
        String classPath = Objects.requireNonNull(clazz.getResource(className)).toString();
        if (!classPath.startsWith("jar:file:")) {
            return null;
        }
        int offset = classPath.lastIndexOf("!");
        assert (offset > 0);
        String manifestPath = classPath.substring(0, offset + 1);
        return VersionUtil.getImplementationVersion(manifestPath);
    }

    public static String getImplementationVersion(String manifestPath) {
        Manifest manifest;
        manifestPath = manifestPath + "/META-INF/MANIFEST.MF";
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
        }
        catch (IOException ignored) {
            return null;
        }
        return manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public static String getPomVersion() {
        String cmd = "mvn help:evaluate -Dexpression=project.version -q -DforceStdout";
        Process process = null;
        InputStreamReader isr = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            isr = new InputStreamReader(process.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String string = br.readLine();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static class Version
    implements Comparable<Version> {
        private final String version;
        private final int[] parts;

        public static Version of(Class<?> clazz) {
            return Version.of(clazz, null);
        }

        public static Version of(Class<?> clazz, String defaultValue) {
            String v = VersionUtil.getImplementationVersion(clazz);
            if (v == null) {
                v = defaultValue;
            }
            return v == null ? null : new Version(v);
        }

        public static Version of(String version) {
            return new Version(version);
        }

        public Version(String version) {
            E.checkArgumentNotNull(version, "The version is null", new Object[0]);
            E.checkArgument(version.matches("[0-9]+(\\.[0-9]+)*"), "Invalid version format: %s", version);
            this.version = version;
            this.parts = Version.parseVersion(version);
        }

        private static int[] parseVersion(String version) {
            String[] parts = version.split("\\.");
            int[] partsNumber = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                partsNumber[i] = Integer.parseInt(parts[i]);
            }
            return partsNumber;
        }

        public final String get() {
            return this.version;
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            int[] thisParts = this.parts;
            int[] thatParts = that.parts;
            int length = Math.max(thisParts.length, thatParts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < thisParts.length ? thisParts[i] : 0;
                int n = thatPart = i < thatParts.length ? thatParts[i] : 0;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            return this.compareTo((Version)that) == 0;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = this.parts.length - 1; i >= 0; --i) {
                int part = this.parts[i];
                if (part == 0 && hash == 0) continue;
                hash = 31 * hash + Integer.hashCode(part);
            }
            return hash;
        }

        public String toString() {
            return this.version;
        }
    }
}

