/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.struct;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.loader.constant.Checkable;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.constant.Unique;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.structure.graph.UpdateStrategy;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.HashUtil;

@Deprecated
public abstract class ElementStructV1
implements Unique<String>,
Checkable {
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="skip")
    private boolean skip = false;
    @JsonProperty(value="input")
    private InputSource input;
    @JsonProperty(value="field_mapping")
    private Map<String, String> mappingFields = new HashMap<String, String>();
    @JsonProperty(value="value_mapping")
    private Map<String, Map<String, Object>> mappingValues = new HashMap<String, Map<String, Object>>();
    @JsonProperty(value="selected")
    private Set<String> selectedFields = new HashSet<String>();
    @JsonProperty(value="ignored")
    private Set<String> ignoredFields = new HashSet<String>();
    @JsonProperty(value="null_values")
    private Set<Object> nullValues = ImmutableSet.of((Object)"");
    @JsonProperty(value="update_strategies")
    private Map<String, UpdateStrategy> updateStrategies = new HashMap<String, UpdateStrategy>();
    private transient String uniqueKey = null;

    public abstract ElemType type();

    @Override
    public String uniqueKey() {
        if (this.uniqueKey == null) {
            String hashCode = HashUtil.hash((String)JsonUtil.toJson(this));
            this.uniqueKey = this.label + "-" + hashCode;
        }
        return this.uniqueKey;
    }

    public String uniqueKeyForFile() {
        String key = this.uniqueKey();
        if (key.endsWith("failure")) {
            return key.replace("-failure", "");
        }
        return key;
    }

    public void setFailureUniqueKey() {
        this.uniqueKey = this.uniqueKey() + "-" + "failure";
    }

    @Override
    public void check() throws IllegalArgumentException {
        E.checkArgument((this.label != null && !this.label.isEmpty() ? 1 : 0) != 0, (String)"The label can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((this.selectedFields.isEmpty() || this.ignoredFields.isEmpty() ? 1 : 0) != 0, (String)"Not allowed to specify selected(%s) and ignored(%s) fields at the same time, at least one of them must be empty", (Object[])new Object[]{this.selectedFields, this.ignoredFields});
        this.mappingFields.values().forEach(value -> E.checkArgument((value != null ? 1 : 0) != 0, (String)"The value in field_mapping can't be null", (Object[])new Object[0]));
        this.mappingValues.values().forEach(m -> m.values().forEach(value -> E.checkArgument((value != null ? 1 : 0) != 0, (String)"The value in value_mapping can't be null", (Object[])new Object[0])));
    }

    public String label() {
        return this.label;
    }

    public boolean skip() {
        return this.skip;
    }

    public InputSource input() {
        return this.input;
    }

    public void input(InputSource input) {
        this.input = input;
    }

    public Map<String, String> mappingFields() {
        return this.mappingFields;
    }

    public String mappingField(String fieldName) {
        String mappingName = this.mappingFields.get(fieldName);
        return mappingName != null ? mappingName : fieldName;
    }

    public Map<String, Map<String, Object>> mappingValues() {
        return this.mappingValues;
    }

    public Object mappingValue(String fieldName, String rawValue) {
        Object value;
        Object mappingValue = rawValue;
        Map<String, Object> values = this.mappingValues.get(fieldName);
        if (values != null && (value = values.get(rawValue)) != null) {
            mappingValue = value;
        }
        return mappingValue;
    }

    public Set<String> selectedFields() {
        return this.selectedFields;
    }

    public Set<String> ignoredFields() {
        return this.ignoredFields;
    }

    public Set<Object> nullValues() {
        return this.nullValues;
    }

    public Map<String, UpdateStrategy> updateStrategies() {
        return this.updateStrategies;
    }
}

