/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.kie.kogito.serverless.workflow.suppliers;

import java.util.Collection;
import java.util.function.Supplier;

import org.kogito.workitem.rest.decorators.CollectionParamsDecorator;

import com.github.javaparser.ast.expr.Expression;

import static org.jbpm.compiler.canonical.descriptors.ExpressionUtils.getObjectCreationExpr;

public class CollectionParamsDecoratorSupplier extends CollectionParamsDecorator implements Supplier<Expression> {

    private final Expression expression;

    public CollectionParamsDecoratorSupplier(Collection<String> headerParams, Collection<String> queryParams) {
        super(headerParams, queryParams);
        expression = getObjectCreationExpr(CollectionParamsDecorator.class, headerParams, queryParams);
    }

    @Override
    public Expression get() {
        return expression;
    }
}
