/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.kie.kogito.serverless.workflow;

public class SWFConstants {

    public static final String DEFAULT_WORKFLOW_VAR = "workflowdata";
    public static final String INPUT_WORKFLOW_VAR = "workflowdatainput";
    public static final String RESULT = "Result";
    public static final String MODEL_WORKFLOW_VAR = "Parameter";
    public static final String CONTENT_DATA = "ContentData";
    public static final String SCRIPT = "script";
    public static final String PYTHON_SCRIPT = "python_script";
    public static final String PYTHON_SVC = "python_svc";
    public static final String PYTHON = "python";
    public static final String JAVA = "Java";
    public static final String WORKITEM_INTERFACE_IMPL = "interfaceImplementationRef";
    public static final String WORKITEM_OPERATION_IMPL = "operationImplementationRef";
    public static final String WORKITEM_INTERFACE = "Interface";
    public static final String WORKITEM_OPERATION = "Operation";
    public static final String SERVICE_TASK_TYPE = "Service Task";
    public static final String SERVICE_IMPL_KEY = "implementation";
    public static final String STATE_NAME = "state";
    public static final String BRANCH_NAME = "branch";
    public static final String ACTION_NAME = "action";

    private SWFConstants() {
    }
}
