/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.util.List;
import org.apache.livy.Job;
import org.apache.livy.JobHandle;
import org.apache.livy.rsc.BypassJobStatus;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.driver.JobWrapper;
import org.apache.livy.rsc.driver.RSCDriver;

public class BypassJobWrapper
extends JobWrapper<byte[]> {
    private volatile byte[] result;
    private volatile Throwable error;
    private volatile JobHandle.State state = JobHandle.State.QUEUED;
    private volatile List<Integer> newSparkJobs;

    public BypassJobWrapper(RSCDriver driver, String jobId, Job<byte[]> serializedJob) {
        super(driver, jobId, serializedJob);
    }

    @Override
    public Void call() throws Exception {
        this.state = JobHandle.State.STARTED;
        return super.call();
    }

    @Override
    protected synchronized void finished(byte[] result, Throwable error) {
        if (error == null) {
            this.result = result;
            this.state = JobHandle.State.SUCCEEDED;
        } else {
            this.error = error;
            this.state = JobHandle.State.FAILED;
        }
    }

    @Override
    boolean cancel() {
        if (super.cancel()) {
            this.state = JobHandle.State.CANCELLED;
            return true;
        }
        return false;
    }

    @Override
    protected void jobStarted() {
    }

    synchronized BypassJobStatus getStatus() {
        String stackTrace = this.error != null ? Utils.stackTraceAsString(this.error) : null;
        return new BypassJobStatus(this.state, this.result, stackTrace);
    }
}

