/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.joda.convert.StringConverter;

abstract class ReflectionStringConverter<T>
implements StringConverter<T> {
    private final Class<T> cls;
    private final Method toString;

    ReflectionStringConverter(Class<T> cls, Method toString) {
        if (toString.getParameterTypes().length != 0) {
            throw new IllegalStateException("ToString method must have no parameters: " + toString);
        }
        if (toString.getReturnType() != String.class) {
            throw new IllegalStateException("ToString method must return a String: " + toString);
        }
        this.cls = cls;
        this.toString = toString;
    }

    @Override
    public String convertToString(T object) {
        try {
            return (String)this.toString.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Method is not accessible: " + this.toString);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
    }

    public String toString() {
        return "RefectionStringConverter[" + this.cls.getSimpleName() + "]";
    }
}

