/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.dubbo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.bo.Bean;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.dubbo.DubboCall;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Reference;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Service;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin
public class DubboPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(DubboPlugin.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private ProtocolConfig protocol;

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        log.info("init dubbo plugin");
        Config config = (Config)ioc.getBean(Config.class);
        this.applicationConfig = new ApplicationConfig(config.get("dubbo_app_name", ""));
        this.applicationConfig.setQosEnable(Boolean.valueOf(false));
        this.registryConfig = new RegistryConfig(config.get("dubbo_reg_address", ""));
        this.registryConfig.setCheck(Boolean.valueOf(config.get("dubbo_reg_check", Boolean.FALSE.toString())));
        HashMap m = Maps.newHashMap();
        m.put("namingLoadCacheAtStart", config.get("dubbo_load_cache_at_start", Boolean.TRUE.toString()));
        this.registryConfig.setParameters((Map)m);
        int dubboPort = Integer.valueOf(config.get("dubbo_port", "-1"));
        int dubboThreads = Integer.valueOf(config.get("dubbo_threads", "200"));
        this.protocol = this.getProtocolConfig(dubboPort, dubboThreads);
        ioc.putBean((Object)this.applicationConfig);
        ioc.putBean((Object)this.registryConfig);
        try {
            Class<?> clazz = Class.forName("org.apache.dubbo.config.bootstrap.DubboBootstrap");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object obj = method.invoke(null, new Object[0]);
            Method applicationMethod = clazz.getMethod("application", ApplicationConfig.class);
            Method registryMethod = clazz.getMethod("registry", RegistryConfig.class);
            Method protocolMethod = clazz.getMethod("protocol", ProtocolConfig.class);
            obj = applicationMethod.invoke(obj, this.applicationConfig);
            obj = registryMethod.invoke(obj, this.registryConfig);
            protocolMethod.invoke(obj, this.protocol);
        }
        catch (Throwable ex) {
            log.info(ex.getMessage());
        }
        DubboCall dubboCall = new DubboCall(this.applicationConfig, this.registryConfig);
        ioc.putBean((Object)dubboCall);
    }

    public void initService(Ioc ioc, Bean bean) {
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setApplication(this.applicationConfig);
        serviceConfig.setRegistry(this.registryConfig);
        Service s = bean.getClazz().getAnnotation(Service.class);
        serviceConfig.setInterface(s.interfaceClass());
        serviceConfig.setRef(bean.getObj());
        serviceConfig.setGroup(this.getGroup(ioc, s.group()));
        serviceConfig.setVersion(this.getVersion(ioc, s.version()));
        serviceConfig.setProtocol(this.protocol);
        serviceConfig.setTimeout(Integer.valueOf(s.timeout()));
        serviceConfig.setAsync(Boolean.valueOf(s.async()));
        serviceConfig.export();
    }

    private ProtocolConfig getProtocolConfig(int dubboPort, int dubboThreads) {
        ProtocolConfig protocol = new ProtocolConfig();
        protocol.setName("dubbo");
        protocol.setPort(Integer.valueOf(dubboPort));
        protocol.setThreads(Integer.valueOf(dubboThreads));
        return protocol;
    }

    public List<Class<? extends Annotation>> filterAnnotations() {
        return Lists.newArrayList((Object[])new Class[]{Service.class});
    }

    public Bean initBean(Ioc ioc, Bean bean) {
        Service s = bean.getClazz().getAnnotation(Service.class);
        if (Optional.ofNullable(s).isPresent()) {
            this.initService(ioc, bean);
        }
        return bean;
    }

    public Optional<String> ioc(Ioc ioc, Class type, Annotation[] annotations) {
        Optional optional = this.getAnno(annotations, Reference.class);
        if (optional.isPresent()) {
            Reference reference = (Reference)optional.get();
            ReferenceConfig referenceConfig = new ReferenceConfig();
            referenceConfig.setApplication(this.applicationConfig);
            referenceConfig.setRegistry(this.registryConfig);
            referenceConfig.setInterface(reference.interfaceClass());
            referenceConfig.setGroup(this.getGroup(ioc, reference.group()));
            referenceConfig.setCheck(Boolean.valueOf(reference.check()));
            referenceConfig.setVersion(this.getVersion(ioc, reference.version()));
            referenceConfig.setTimeout(Integer.valueOf(reference.timeout()));
            referenceConfig.setCluster(reference.cluster());
            Object service = referenceConfig.get();
            ioc.putBean(reference.interfaceClass().getName(), service);
            return Optional.of(reference.interfaceClass().getName());
        }
        return Optional.empty();
    }

    private String getGroup(Ioc ioc, String group) {
        if (group.startsWith("$")) {
            return (String)ioc.getBean(group);
        }
        return group;
    }

    private String getVersion(Ioc ioc, String version) {
        if (version.startsWith("$")) {
            return (String)ioc.getBean(version);
        }
        return version;
    }

    public boolean disable(Ioc ioc) {
        Config config = (Config)ioc.getBean(Config.class);
        return Boolean.valueOf(config.get("disable_dubbo_plugin", "false"));
    }

    public String version() {
        return "0.0.1:2021-01-16";
    }
}

