/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.service;

import com.xiaomi.youpin.docean.anno.Service;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.operator.common.ESIndexConst;
import org.apache.ozhera.operator.common.HttpClientUtil;

@Service
public class ESService {
    private Base64.Encoder base64 = Base64.getEncoder();

    public void createESTemplate(String esUrl, String userName, String password) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password)) {
            headers.put("Authorization", this.generateOuth2(userName, password));
        }
        headers.put("Content-type", "application/json; charset=UTF-8");
        for (String indexName : ESIndexConst.templates.keySet()) {
            HttpClientUtil.sendPostRequest((String)this.generateUrl(esUrl, indexName), (String)((String)ESIndexConst.templates.get(indexName)), headers);
        }
    }

    private String generateUrl(String esUrl, String index) {
        return "http://" + esUrl + "/_template/" + index;
    }

    private String generateOuth2(String userName, String password) {
        String oriStr = userName + ":" + password;
        String base64Str = new String(this.base64.encode(oriStr.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        return "Basic " + base64Str;
    }
}

