/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.xiaomi.mone.tpc.login.filter.HttpReqUserFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterConfiguration {
    @NacosValue(value="${aegis.sdk.hera.public.key:noconfig}")
    private String aegisSdkHera;
    @NacosValue(value="${aegis.sdk.log.public.key:noconfig}")
    private String aegisSdkLog;
    @NacosValue(value="${aegis.mione.public.domain.key:noconfig}")
    private String mionePublicDomain;
    @NacosValue(value="${token.parse.url}", autoRefreshed=true)
    private String tokenParseUrl;
    @Value(value="${inner.auth}")
    private String innerAuth;
    @Value(value="${dev.mode}")
    private String devMode;
    @NacosValue(value="${login.url}", autoRefreshed=true)
    private String loginUrl;

    @Bean
    public FilterRegistrationBean filterCasBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new HttpReqUserFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.addInitParameter("innerAuth", this.innerAuth);
        String value = this.aegisSdkHera + "," + this.aegisSdkLog + "," + this.mionePublicDomain;
        registrationBean.addInitParameter("AEGIS_SDK_PUBLIC_KEY", value);
        registrationBean.addInitParameter("authTokenUrl", this.tokenParseUrl);
        registrationBean.addInitParameter("IGNORE_URL", "js/*,/api/*,/alert/*,/manual/*,/prometheus/queryIncrease,/prometheus/detail,/prometheus/logInfo,/prometheus/getTeslaError,/alertGroup/test,/mimonitor/alarmUnHealthSendFeishu,/mimonitor/alarmResourceUtilization,/mimonitor/alarmUnHealthSendFeishu,/mimonitor/createGrafanaBlackList,/mimonitor/getGrafanaBlackList,/mimonitor/delGrafanaBlackList,/mimonitor/getGrafanaBlackListList,/mimonitor/testGrafanaCreate,/mimonitor/historyInstance");
        registrationBean.addInitParameter("devMode", this.devMode);
        registrationBean.addInitParameter("loginUrl", this.loginUrl);
        registrationBean.setOrder(0);
        return registrationBean;
    }
}

