/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.es.consumer;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.base.Joiner;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.ozhera.trace.etl.api.service.DataSourceService;
import org.apache.ozhera.trace.etl.es.consumer.FilterService;
import org.apache.ozhera.trace.etl.es.domain.FilterResult;
import org.apache.ozhera.trace.etl.es.domain.LocalStorages;
import org.apache.ozhera.trace.etl.es.queue.impl.RocksdbStoreServiceImpl;
import org.apache.ozhera.trace.etl.es.queue.impl.TeSnowFlake;
import org.apache.ozhera.trace.etl.es.util.bloomfilter.TraceIdRedisBloomUtil;
import org.apache.ozhera.trace.etl.util.ExecutorUtil;
import org.apache.ozhera.trace.etl.util.ThriftUtil;
import org.apache.ozhera.tspandata.TAttributeKey;
import org.apache.ozhera.tspandata.TAttributeType;
import org.apache.ozhera.tspandata.TAttributes;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.ozhera.tspandata.TValue;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConsumerService {
    private static final Logger log = LoggerFactory.getLogger(ConsumerService.class);
    @Value(value="${rocks.first.gap}")
    private long firstGap;
    @Value(value="${rocks.second.gap}")
    private long secondGap;
    @Value(value="${rocks.first.path}")
    private String firstRocksPath;
    @Value(value="${rocks.second.path}")
    private String secondRocksPath;
    @NacosValue(value="${trace.es.filter.isopen}", autoRefreshed=true)
    private boolean filterIsOpen;
    @Autowired
    private TraceIdRedisBloomUtil traceIdRedisBloomUtil;
    @Autowired
    private FilterService filterService;
    @Autowired
    private DataSourceService writeEsService;
    @Autowired
    private TeSnowFlake snowFlake;
    private RocksdbStoreServiceImpl firstRocksdbStoreService;
    private RocksdbStoreServiceImpl secondRocksdbStoreService;
    private AtomicInteger firstCount = new AtomicInteger();
    private AtomicInteger secondCount = new AtomicInteger();
    private CopyOnWriteArrayList<String> firstList = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<String> secondList = new CopyOnWriteArrayList();
    private ReentrantLock firstLock = new ReentrantLock();
    private ReentrantLock secondLock = new ReentrantLock();
    private static final int BATCH_ROCKSDB_COUNT = 20;
    private static final Object FIRST_LOCK = new Object();
    private static final Object SECOND_LOCK = new Object();

    @PostConstruct
    public void init() {
        if (this.filterIsOpen) {
            this.firstRocksdbStoreService = new RocksdbStoreServiceImpl(this.firstRocksPath, "first_new");
            this.secondRocksdbStoreService = new RocksdbStoreServiceImpl(this.secondRocksPath, "second_new");
            this.initFirstRocksTask();
            this.initSecondRocksTask();
        }
    }

    private void dealMessage(String order, String message) {
        String[] messages;
        if (StringUtils.isEmpty((CharSequence)message)) {
            return;
        }
        for (String oneMessage : messages = message.split(" #### ")) {
            String[] split = oneMessage.split(" ### ");
            TSpanData tSpanData = this.deserializeFromString(split[3]);
            if (tSpanData == null) continue;
            if (this.traceIdRedisBloomUtil.isExistLocal(split[0])) {
                this.writeEsService.insertHeraSpan(tSpanData, split[1], split[2]);
                continue;
            }
            if (!"first".equals(order)) continue;
            this.insertRocks(split[0], split[1], split[2], tSpanData, "second");
        }
    }

    public void consumer(TSpanData tSpanData) {
        try {
            Long duration;
            String spanName;
            String traceId;
            FilterResult filter;
            if (tSpanData == null) {
                log.error("tSpanData is null");
                return;
            }
            String status = tSpanData.getStatus().name();
            String heraContext = "";
            TAttributes attributes = tSpanData.getAttributes();
            List tagsKeys = attributes.getKeys();
            List tagsValues = attributes.getValues();
            if (tagsKeys != null && tagsValues != null && tagsKeys.size() > 0 && tagsKeys.size() != tagsValues.size()) {
                for (int i = 0; i < tagsKeys.size(); ++i) {
                    String key = ((TAttributeKey)tagsKeys.get(i)).getValue();
                    String value = ThriftUtil.getStringValue((TValue)((TValue)tagsValues.get(i)), (TAttributeType)((TAttributeKey)tagsKeys.get(i)).getType());
                    if (!this.filterIsOpen || !"span.hera_context".equals(key)) continue;
                    heraContext = value;
                }
            }
            String serviceName = "unknow-service";
            if (tSpanData.getExtra() != null && StringUtils.isNotEmpty((CharSequence)tSpanData.getExtra().getServiceName())) {
                serviceName = tSpanData.getExtra().getServiceName();
            }
            if ((filter = this.filterService.filterBefore(status, traceId = tSpanData.getTraceId(), spanName = tSpanData.getName(), heraContext, serviceName, duration = Long.valueOf(tSpanData.getEndEpochNanos() - tSpanData.getStartEpochNanos()), tSpanData)).isDiscard()) {
                return;
            }
            if (filter.isResult()) {
                if (filter.isAddBloom()) {
                    this.traceIdRedisBloomUtil.addBatch(traceId);
                }
                this.writeEsService.insertHeraSpan(tSpanData, serviceName, spanName);
            } else {
                this.insertRocks(traceId, serviceName, spanName, tSpanData, "first");
            }
        }
        catch (Throwable e) {
            log.error("message parse error, message : " + tSpanData.toString(), e);
            return;
        }
    }

    private void insertRocks(String traceId, String serviceName, String spanName, TSpanData tSpanData, String order) {
        if (this.filterIsOpen) {
            if ("first".equals(order)) {
                this.internatInset(traceId, serviceName, spanName, tSpanData, order);
            } else if ("second".equals(order)) {
                this.internatInset(traceId, serviceName, spanName, tSpanData, order);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internatInset(String traceId, String serviceName, String spanName, TSpanData tSpanData, String order) {
        String m = this.buildRocksDBMessage(traceId, serviceName, spanName, tSpanData, order);
        if (StringUtils.isEmpty((CharSequence)m)) {
            return;
        }
        long currSeconds = System.currentTimeMillis() / 1000L;
        if ("first".equals(order)) {
            int j = this.firstCount.getAndUpdate(i -> {
                if (i >= 20) {
                    return 0;
                }
                return i;
            });
            MutableObject mo = new MutableObject();
            this.firstLock.lock();
            try {
                this.firstList.add(m);
                if (j >= 20) {
                    String msg = Joiner.on((String)"").join(this.firstList);
                    mo.setValue((Object)msg);
                    this.firstList.clear();
                }
            }
            finally {
                this.firstLock.unlock();
            }
            if (j >= 20) {
                String key = this.firstRocksdbStoreService.getKey(currSeconds, LocalStorages.firstRocksKeySuffix.addAndGet(1L));
                this.firstRocksdbStoreService.put(key, ((String)mo.getValue()).getBytes(StandardCharsets.UTF_8));
            }
        } else if ("second".equals(order)) {
            int j = this.secondCount.getAndUpdate(i -> {
                if (i >= 20) {
                    return 0;
                }
                return i;
            });
            MutableObject mo = new MutableObject();
            this.secondLock.lock();
            try {
                this.secondList.add(m);
                if (j >= 20) {
                    String msg = Joiner.on((String)"").join(this.secondList);
                    mo.setValue((Object)msg);
                    this.secondList.clear();
                }
            }
            finally {
                this.secondLock.unlock();
            }
            if (j >= 20) {
                String key = this.secondRocksdbStoreService.getKey(currSeconds, LocalStorages.secondRocksKeySuffix.addAndGet(1L));
                this.secondRocksdbStoreService.put(key, ((String)mo.getValue()).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private String buildRocksDBMessage(String traceId, String serviceName, String spanName, TSpanData tSpanData, String order) {
        String serialize = this.serializeToString(tSpanData);
        if (serialize != null) {
            if ("first".equals(order)) {
                StringBuilder sb = new StringBuilder();
                sb.append(traceId).append(" ### ").append(serviceName).append(" ### ").append(spanName).append(" ### ").append(serialize).append(" #### ");
                this.firstCount.incrementAndGet();
                return sb.toString();
            }
            if ("second".equals(order)) {
                StringBuilder sb = new StringBuilder();
                sb.append(traceId).append(" ### ").append(serviceName).append(" ### ").append(spanName).append(" ### ").append(serialize).append(" #### ");
                this.secondCount.incrementAndGet();
                return sb.toString();
            }
        }
        return "";
    }

    private void initFirstRocksTask() {
        String firstKey = this.snowFlake.recoverLastTimestamp("first_new");
        String firstLastRocksKey = firstKey == null ? System.currentTimeMillis() + "_" + LocalStorages.firstRocksKeySuffix.get() : firstKey;
        ExecutorUtil.submitRocksDBRead(() -> {
            try {
                this.firstRocksdbStoreService.delayTake(firstLastRocksKey, this.firstGap, new Consumer<byte[]>(){

                    @Override
                    public void accept(byte[] bytes) {
                        ExecutorUtil.submitDelayMessage(() -> {
                            try {
                                String firstRocksMes = new String(bytes);
                                ConsumerService.this.dealMessage("first", firstRocksMes);
                            }
                            catch (Throwable t) {
                                log.error("deal first rocksdb message error : ", t);
                            }
                        });
                    }
                }, this.snowFlake);
            }
            catch (Throwable e) {
                log.error("first get Rocks message error : ", e);
            }
        });
    }

    private void initSecondRocksTask() {
        String secondKey = this.snowFlake.recoverLastTimestamp("second_new");
        String secondLastRocksKey = secondKey == null ? System.currentTimeMillis() + "_" + LocalStorages.secondRocksKeySuffix.get() : secondKey;
        ExecutorUtil.submitRocksDBRead(() -> {
            try {
                this.secondRocksdbStoreService.delayTake(secondLastRocksKey, this.secondGap, new Consumer<byte[]>(){

                    @Override
                    public void accept(byte[] bytes) {
                        ExecutorUtil.submitDelayMessage(() -> {
                            try {
                                String firstRocksMes = new String(bytes);
                                ConsumerService.this.dealMessage("second", firstRocksMes);
                            }
                            catch (Throwable t) {
                                log.error("deal second rocksdb message error : ", t);
                            }
                        });
                    }
                }, this.snowFlake);
            }
            catch (Throwable e) {
                log.error("second get Rocks message error : ", e);
            }
        });
    }

    private String serializeToString(TSpanData tSpanData) {
        try {
            byte[] serialize = new TSerializer(ThriftUtil.PROTOCOL_FACTORY).serialize((TBase)tSpanData);
            return new String(serialize, StandardCharsets.ISO_8859_1);
        }
        catch (Throwable e) {
            log.error("rocksDB serializer serialize error");
            return null;
        }
    }

    private TSpanData deserializeFromString(String decode) {
        try {
            TSpanData tSpanData = new TSpanData();
            new TDeserializer(ThriftUtil.PROTOCOL_FACTORY).deserialize((TBase)tSpanData, decode.getBytes(StandardCharsets.ISO_8859_1));
            return tSpanData;
        }
        catch (Throwable e) {
            log.error("rocksDB deserializer deserialize error");
            return null;
        }
    }
}

