/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.dao.SqlManager;
import org.nutz.dao.SqlNotFoundException;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.LinkedCharArray;

public abstract class AbstractSqlManager
implements SqlManager {
    protected Map<String, String> _sql_map;
    private List<String> _sql_keys;
    private boolean allowDuplicate = true;
    static final Pattern ptn = Pattern.compile("(?<=^\n/[*])(.*)(?=[*]/)");

    private Map<String, String> map() {
        if (null == this._sql_map) {
            this.refresh();
        }
        return this._sql_map;
    }

    private List<String> keylist() {
        if (null == this._sql_keys) {
            this.refresh();
        }
        return this._sql_keys;
    }

    public boolean contains(String key) {
        return this.map().containsKey(key);
    }

    public void saveAs(File f) throws IOException {
        Writer w = Streams.fileOutw(f);
        for (String key : this.keylist()) {
            w.append("/*").append(Strings.dup('-', 60)).append("*/\n");
            String sql = this.map().get(key);
            w.append(String.format("/*%s*/\n", key));
            w.append(sql).append('\n');
        }
        w.flush();
        w.close();
    }

    @Override
    public String get(String key) {
        String sql = this.map().get(key);
        if (null == sql) {
            throw new SqlNotFoundException(key);
        }
        return sql;
    }

    @Override
    public Sql create(String key) throws SqlNotFoundException {
        return Sqls.create(this.get(key));
    }

    @Override
    public List<Sql> createCombo(String ... keys) {
        if (null == keys || keys.length == 0) {
            keys = this.keys();
        }
        ArrayList<Sql> list = new ArrayList<Sql>(keys.length);
        for (String key : keys) {
            Sql sql = this.create(key);
            list.add(sql);
        }
        return list;
    }

    @Override
    public int count() {
        return this.map().size();
    }

    @Override
    public String[] keys() {
        return this.keylist().toArray(new String[this.keylist().size()]);
    }

    @Override
    public void addSql(String key, String value) {
        if (this.map().containsKey(key) && !this.allowDuplicate) {
            throw Lang.makeThrow("duplicate key '%s'", key);
        }
        key = Strings.trim(key);
        this.map().put(key, value);
        this.keylist().add(key);
    }

    @Override
    public void remove(String key) {
        this.keylist().remove(key);
        this.map().remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSQL(Reader reader) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            SqlFileBuilder p = new SqlFileBuilder(bufferedReader);
            this._sql_keys = new ArrayList<String>(p.map.size());
            for (Map.Entry<String, String> en : p.entrySet()) {
                this.addSql(en.getKey(), Strings.trim(en.getValue()));
            }
        }
        catch (Throwable throwable) {
            Streams.safeClose(bufferedReader);
            throw throwable;
        }
        Streams.safeClose(bufferedReader);
    }

    public void setAllowDuplicate(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
    }

    static class SqlFileBuilder {
        LinkedHashMap<String, String> map;

        SqlFileBuilder(BufferedReader reader) throws IOException {
            int c;
            InnerStack stack = new InnerStack();
            stack.eat(10);
            while (-1 != (c = reader.read())) {
                stack.eat(c);
            }
            if (stack.key != null) {
                stack.addOne();
            }
            this.map = stack.map;
            Streams.safeClose(reader);
        }

        Set<String> keys() {
            return this.map.keySet();
        }

        String get(String key) {
            return this.map.get(key);
        }

        Set<Map.Entry<String, String>> entrySet() {
            return this.map.entrySet();
        }
    }

    static class InnerStack {
        LinkedHashMap<String, String> map = new LinkedHashMap();
        LinkedCharArray list = new LinkedCharArray();
        LinkedCharArray cmts = new LinkedCharArray();
        String key = null;
        boolean inNormalComment;

        InnerStack() {
        }

        void eat(int c) {
            Matcher matcher;
            if (this.inNormalComment) {
                if (this.cmts.push(c).endsWith("*/")) {
                    this.cmts.clear();
                    this.inNormalComment = false;
                }
            } else if (this.key != null) {
                if (this.list.push(c).endsWith("\n/*")) {
                    this.list.popLast(3);
                    this.addOne();
                    this.list.push("\n/*");
                } else if (this.list.endsWith("/*")) {
                    this.list.popLast(2);
                    this.inNormalComment = true;
                }
            } else if (this.list.size() < 3) {
                if (!"\n/*".startsWith(this.list.push(c).toString())) {
                    this.list.clear();
                }
            } else if (this.list.push(c).endsWith("*/") && (matcher = ptn.matcher(this.list.popAll())).find()) {
                this.key = Strings.trim(matcher.group());
            }
        }

        void addOne() {
            String value = Strings.trim(this.list.popAll());
            if (!Strings.isBlank(value)) {
                this.map.put(this.key, value);
            }
            this.key = null;
        }
    }
}

