/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.impl.entity.MapEntityMaker;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;

public class EntityHolder {
    public EntityMaker maker;
    protected JdbcExpert expert;
    private Map<Class<?>, Entity<?>> map;
    protected DataSource dataSource;
    protected MapEntityMaker mapEntityMaker;

    public EntityHolder(JdbcExpert expert, DataSource dataSource) {
        this.expert = expert;
        this.dataSource = dataSource;
        this.map = new ConcurrentHashMap();
        this.mapEntityMaker = new MapEntityMaker();
        this.mapEntityMaker.init(dataSource, expert, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Entity<?> en) {
        Map<Class<?>, Entity<?>> map = this.map;
        synchronized (map) {
            this.map.put(en.getType(), en);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entity<?> en) {
        if (en == null || en.getType() == null) {
            return;
        }
        Map<Class<?>, Entity<?>> map = this.map;
        synchronized (map) {
            this.map.remove(en.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Entity<T> getEntity(Class<T> classOfT) {
        Entity<Object> re = this.map.get(classOfT);
        if (null == re || !re.isComplete()) {
            Map<Class<?>, Entity<?>> map = this.map;
            synchronized (map) {
                re = this.map.get(classOfT);
                if (null == re) {
                    re = this.maker.make(classOfT);
                }
            }
        }
        return re;
    }

    public <T extends Map<String, ?>> Entity<T> makeEntity(String tableName, T map) {
        return this.mapEntityMaker.make(tableName, map);
    }

    public Entity<?> getEntityBy(Object obj) {
        Object first = Lang.first(obj);
        if (first == null) {
            return null;
        }
        if (first instanceof Map) {
            Object tableName = ((Map)first).get(".table");
            if (null == tableName) {
                throw Lang.makeThrow("Can not insert map without key '.table' : \n%s", Json.toJson(first, JsonFormat.forLook()));
            }
            return this.makeEntity(tableName.toString(), (Map)first);
        }
        return this.getEntity(first.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasType(Class<?> typeName) {
        Map<Class<?>, Entity<?>> map = this.map;
        synchronized (map) {
            return this.map.containsKey(typeName);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public void remove(String className) {
        HashSet keys = new HashSet(this.map.keySet());
        for (Class clazz : keys) {
            if (!clazz.getName().equals(className)) continue;
            this.map.remove(clazz);
        }
    }
}

