/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.dao.DaoException;
import org.nutz.dao.FieldMatcher;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityIndex;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.LinkVisitor;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.entity.Record;
import org.nutz.dao.impl.entity.EntityName;
import org.nutz.dao.impl.entity.EntityObjectContext;
import org.nutz.dao.impl.entity.LinkFieldSet;
import org.nutz.dao.sql.Pojo;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.born.BornContext;
import org.nutz.lang.born.Borning;
import org.nutz.lang.born.Borns;
import org.nutz.lang.util.Context;

public class NutEntity<T>
implements Entity<T> {
    private static final Object[] EMTRY_ARG = new Object[0];
    private Map<String, MappingField> byJava;
    private Map<String, MappingField> byDB;
    private List<MappingField> fields;
    private List<EntityIndex> indexes;
    private Map<String, EntityIndex> indexMap;
    private List<MappingField> theComposites;
    private List<Pojo> beforeInsertMacroes;
    private List<Pojo> afterInsertMacroes;
    protected LinkFieldSet ones;
    protected LinkFieldSet manys;
    protected LinkFieldSet manymanys;
    private MappingField theId;
    private MappingField theName;
    private MappingField theVersion;
    protected Class<T> type;
    private Mirror<T> mirror;
    protected Borning<T> bornByRS;
    protected Borning<T> bornByDefault;
    private EntityName tableName;
    private String tableComment;
    private Map<String, String> columnComments;
    private boolean hasTableComment;
    private boolean hasColumnComment;
    private EntityName viewName;
    private Map<String, Object> metas;
    private PkType pkType;
    private boolean complete;

    public NutEntity(Class<T> type) {
        this.type = type;
        this.mirror = Mirror.me(type);
        this.byJava = new HashMap<String, MappingField>();
        this.byDB = new HashMap<String, MappingField>();
        this.indexMap = new HashMap<String, EntityIndex>();
        this.fields = new ArrayList<MappingField>(5);
        this.indexes = new ArrayList<EntityIndex>(3);
        this.theComposites = new ArrayList<MappingField>(3);
        this.metas = new HashMap<String, Object>();
        this.columnComments = new HashMap<String, String>();
        this.pkType = PkType.UNKNOWN;
        this.beforeInsertMacroes = new ArrayList<Pojo>(3);
        this.afterInsertMacroes = new ArrayList<Pojo>(3);
        try {
            this.bornByDefault = this.mirror.getBorningByArgTypes(new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BornContext<T> bc = Borns.evalByArgTypes(type, ResultSet.class);
        if (null != bc) {
            this.bornByRS = bc.getBorning();
        } else if (null == this.bornByDefault) {
            throw new DaoException("Need non-arg constructor : " + type);
        }
        this.ones = new LinkFieldSet();
        this.manys = new LinkFieldSet();
        this.manymanys = new LinkFieldSet();
    }

    @Override
    public T getObject(ResultSet rs, FieldMatcher matcher) {
        return this.getObject(rs, matcher, null);
    }

    @Override
    public T getObject(ResultSet rs, FieldMatcher matcher, String prefix) {
        if (null != this.bornByRS) {
            return this.bornByRS.born(rs);
        }
        T re = this.bornByDefault.born(EMTRY_ARG);
        if (null == matcher) {
            for (MappingField fld : this.fields) {
                fld.injectValue(re, rs, prefix);
            }
        } else {
            for (MappingField fld : this.fields) {
                if (!matcher.match(fld.getName())) continue;
                fld.injectValue(re, rs, prefix);
            }
        }
        return re;
    }

    @Override
    public T getObject(Record rec) {
        return this.getObject(rec, null);
    }

    @Override
    public T getObject(Record rec, String prefix) {
        T obj = this.bornByDefault.born(EMTRY_ARG);
        for (MappingField fld : this.fields) {
            fld.injectValue(obj, rec, prefix);
        }
        return obj;
    }

    public void checkCompositeFields(String[] names) {
        if (!Lang.isEmptyArray(names) && names.length > 1) {
            for (String name : names) {
                if (!this.byJava.containsKey(name) || !this.byJava.get(name).isCompositePk()) {
                    throw Lang.makeThrow("Fail to find comosite field '%s' in class '%s'!", name, this.type.getName());
                }
                this.theComposites.add(this.byJava.get(name));
            }
            this.pkType = PkType.COMPOSITE;
        } else if (null != this.theId) {
            this.pkType = PkType.ID;
        } else if (null != this.theName) {
            this.pkType = PkType.NAME;
        }
    }

    public void addMappingField(MappingField field) {
        if (field.isId()) {
            this.theId = field;
        } else if (field.isName()) {
            this.theName = field;
        } else if (field.isVersion()) {
            this.theVersion = field;
        }
        this.byJava.put(field.getName(), field);
        this.byDB.put(field.getColumnName(), field);
        this.fields.add(field);
        this.columnComments.put(field.getName(), field.getColumnComment());
    }

    public void addLinkField(LinkField lnk) {
        switch (lnk.getLinkType()) {
            case ONE: {
                this.ones.add(lnk);
                break;
            }
            case MANY: {
                this.manys.add(lnk);
                break;
            }
            case MANYMANY: {
                this.manymanys.add(lnk);
                break;
            }
            default: {
                throw Lang.makeThrow("It is a miracle in Link field: '%s'(%s)", lnk.getName(), lnk.getEntity().getType().getName());
            }
        }
    }

    public void addIndex(EntityIndex index) {
        this.indexes.add(index);
        this.indexMap.put(index.getName(this), index);
    }

    @Override
    public Context wrapAsContext(Object obj) {
        return new EntityObjectContext(this, obj);
    }

    @Override
    public List<LinkField> visitOne(Object obj, String regex, LinkVisitor visitor) {
        return this.ones.visit(obj, regex, visitor);
    }

    @Override
    public List<LinkField> visitMany(Object obj, String regex, LinkVisitor visitor) {
        return this.manys.visit(obj, regex, visitor);
    }

    @Override
    public List<LinkField> visitManyMany(Object obj, String regex, LinkVisitor visitor) {
        return this.manymanys.visit(obj, regex, visitor);
    }

    public void setTableName(String namep) {
        this.tableName = EntityName.create(namep);
    }

    public void setTableComment(String tComment) {
        this.tableComment = tComment;
    }

    public void setHasTableComment(boolean hasTableComment) {
        this.hasTableComment = hasTableComment;
    }

    public void setHasColumnComment(boolean hasColumnComment) {
        this.hasColumnComment = hasColumnComment;
    }

    public void setBeforeInsertMacroes(List<Pojo> beforeInsertMacroes) {
        this.beforeInsertMacroes = beforeInsertMacroes;
    }

    public void setAfterInsertMacroes(List<Pojo> afterInsertMacroes) {
        this.afterInsertMacroes = afterInsertMacroes;
    }

    public void setViewName(String namep) {
        this.viewName = EntityName.create(namep);
    }

    @Override
    public MappingField getField(String name) {
        return this.byJava.get(name);
    }

    @Override
    public MappingField getColumn(String name) {
        return this.byDB.get(name);
    }

    @Override
    public List<MappingField> getMappingFields() {
        return this.fields;
    }

    @Override
    public List<LinkField> getLinkFields(String regex) {
        List<LinkField> reOnes = this.ones.getList(regex);
        List<LinkField> reManys = this.manys.getList(regex);
        List<LinkField> reManymanys = this.manymanys.getList(regex);
        ArrayList<LinkField> re = new ArrayList<LinkField>(reOnes.size() + reManys.size() + reManymanys.size());
        re.addAll(reOnes);
        re.addAll(reManys);
        re.addAll(reManymanys);
        return re;
    }

    @Override
    public List<MappingField> getCompositePKFields() {
        return this.theComposites;
    }

    @Override
    public MappingField getNameField() {
        return this.theName;
    }

    @Override
    public MappingField getVersionField() {
        return this.theVersion;
    }

    @Override
    public MappingField getIdField() {
        return this.theId;
    }

    @Override
    public List<MappingField> getPks() {
        if (null != this.theId) {
            return Lang.list(this.theId);
        }
        if (null != this.theName) {
            return Lang.list(this.theName);
        }
        return this.theComposites;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Mirror<T> getMirror() {
        return this.mirror;
    }

    @Override
    public List<EntityIndex> getIndexes() {
        return this.indexes;
    }

    @Override
    public EntityIndex getIndex(String name) {
        return this.indexMap.get(name);
    }

    @Override
    public String getTableName() {
        return this.tableName.value();
    }

    @Override
    public String getViewName() {
        return this.viewName.value();
    }

    @Override
    public boolean addBeforeInsertMacro(Pojo pojo) {
        if (null != pojo) {
            this.beforeInsertMacroes.add(pojo);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAfterInsertMacro(Pojo pojo) {
        if (null != pojo) {
            this.afterInsertMacroes.add(pojo);
            return true;
        }
        return false;
    }

    @Override
    public List<Pojo> cloneBeforeInsertMacroes() {
        ArrayList<Pojo> re = new ArrayList<Pojo>(this.beforeInsertMacroes.size());
        for (Pojo pojo : this.beforeInsertMacroes) {
            re.add(pojo.duplicate());
        }
        return re;
    }

    @Override
    public List<Pojo> cloneAfterInsertMacroes() {
        ArrayList<Pojo> re = new ArrayList<Pojo>(this.afterInsertMacroes.size());
        for (Pojo pojo : this.afterInsertMacroes) {
            re.add(pojo.duplicate());
        }
        return re;
    }

    @Override
    public PkType getPkType() {
        return this.pkType;
    }

    @Override
    public Object getMeta(String key) {
        return this.metas.get(key);
    }

    @Override
    public boolean hasMeta(String key) {
        return this.metas.containsKey(key);
    }

    @Override
    public Map<String, Object> getMetas() {
        return this.metas;
    }

    public String toString() {
        return String.format("Entity<%s:%s>", this.getType().getName(), this.getTableName());
    }

    @Override
    public boolean hasTableComment() {
        return this.hasTableComment;
    }

    @Override
    public String getTableComment() {
        return this.tableComment;
    }

    @Override
    public boolean hasColumnComment() {
        return this.hasColumnComment;
    }

    @Override
    public String getColumnComent(String columnName) {
        return this.columnComments.get(columnName);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public T born(ResultSet rs) {
        if (null != this.bornByRS) {
            return this.bornByRS.born(rs);
        }
        return this.bornByDefault.born(EMTRY_ARG);
    }
}

