/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.nutz.dao.Chain;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.impl.sql.NutStatement;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.PItem;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.PojoCallback;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Pojos;
import org.nutz.lang.Lang;

public class NutPojo
extends NutStatement
implements Pojo {
    private static final long serialVersionUID = -8499040181844973777L;
    private PojoCallback before;
    private PojoCallback after;
    private LinkedList<Object> params = new LinkedList();
    private int _pmnum = -1;
    private Object obj;
    protected ArrayList<PItem> items = new ArrayList(6);

    public NutPojo() {
        this.append(Pojos.Items.sqlType());
    }

    @Override
    public ValueAdaptor[] getAdaptors() {
        ValueAdaptor[] adaptors = new ValueAdaptor[this._params_count()];
        int i = 0;
        for (PItem item : this.items) {
            i = item.joinAdaptor(this.getEntity(), adaptors, i);
        }
        return adaptors;
    }

    @Override
    public Object[][] getParamMatrix() {
        Object[][] re;
        if (this._params_count() > 0 && this.params.isEmpty()) {
            re = new Object[1][this._params_count()];
            int i = 0;
            for (PItem pItem : this.items) {
                i = pItem.joinParams(this.getEntity(), null, re[0], i);
            }
        } else {
            re = new Object[this.params.size()][this._params_count()];
            int row = 0;
            for (Object e : this.params) {
                int i = 0;
                for (PItem item : this.items) {
                    i = item.joinParams(this.getEntity(), e, re[row], i);
                }
                ++row;
            }
        }
        return re;
    }

    @Override
    public String toPreparedStatement() {
        StringBuilder sb = new StringBuilder();
        for (PItem item : this.items) {
            item.joinSql(this.getEntity(), sb);
        }
        return sb.toString();
    }

    @Override
    public void onBefore(Connection conn) throws SQLException {
        if (null != this.before) {
            this.before.invoke(conn, null, this, null);
        }
    }

    @Override
    public void onAfter(Connection conn, ResultSet rs, Statement stmt) throws SQLException {
        if (null != this.after) {
            this.getContext().setResult(this.after.invoke(conn, rs, this, stmt));
        }
    }

    @Override
    public Pojo setBefore(PojoCallback before) {
        this.before = before;
        return this;
    }

    @Override
    public Pojo setAfter(PojoCallback after) {
        this.after = after;
        return this;
    }

    @Override
    public Pojo setPager(Pager pager) {
        this.getContext().setPager(pager);
        return this;
    }

    @Override
    public Pojo addParamsBy(Object obj) {
        if (null == obj) {
            return this;
        }
        if (obj instanceof Collection) {
            for (Object ele : (Collection)obj) {
                this.addParamsBy(ele);
            }
        } else if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                this.addParamsBy(Array.get(obj, i));
            }
        } else if (obj instanceof Chain) {
            this.params.add(((Chain)obj).updateBy(this.getEntity()).toMap());
        } else if (obj instanceof Iterator) {
            Iterator it = (Iterator)obj;
            while (it.hasNext()) {
                this.addParamsBy(it.next());
            }
        } else {
            this.params.add(obj);
        }
        return this;
    }

    @Override
    public Object getLastParams() {
        return this.params.isEmpty() ? null : this.params.getLast();
    }

    @Override
    public List<Object> params() {
        return this.params;
    }

    @Override
    public Object getOperatingObject() {
        return this.obj;
    }

    @Override
    public Pojo setOperatingObject(Object obj) {
        this.obj = obj;
        return this;
    }

    @Override
    public Pojo clear() {
        this.params.clear();
        return this;
    }

    @Override
    public Pojo append(PItem ... itemAry) {
        if (null != itemAry) {
            for (PItem item : itemAry) {
                if (null == item) continue;
                this.items.add(item);
                item.setPojo(this);
            }
        }
        return this;
    }

    @Override
    public Pojo insertFirst(PItem ... itemAry) {
        this.items.addAll(0, Lang.list(itemAry));
        for (PItem pi : itemAry) {
            pi.setPojo(this);
        }
        return this;
    }

    @Override
    public Pojo setItem(int index, PItem pi) {
        this.items.set(index, pi);
        pi.setPojo(this);
        return this;
    }

    @Override
    public PItem getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public Pojo removeItem(int index) {
        this.items.remove(index);
        return this;
    }

    @Override
    public NutPojo setSqlType(SqlType sqlType) {
        return (NutPojo)super.setSqlType(sqlType);
    }

    @Override
    public String toString() {
        if (SqlType.RUN == this.getSqlType()) {
            return this.getSqlType().name() + (null == this.before ? "" : " :before{...}") + (null == this.after ? "" : " :after{...}");
        }
        return super.toString();
    }

    @Override
    public Pojo duplicate() {
        throw Lang.noImplement();
    }

    private int _params_count() {
        if (this._pmnum < 0) {
            this._pmnum = 0;
            Entity<?> en = this.getEntity();
            for (PItem item : this.items) {
                this._pmnum += item.paramCount(en);
            }
        }
        return this._pmnum;
    }
}

