/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.meta;

import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class Email
implements Cloneable {
    private String account;
    private String host;

    public Email() {
    }

    public Email(String str) {
        try {
            int pos = str.indexOf(64);
            this.account = str.substring(0, pos);
            this.host = str.substring(pos + 1, str.length());
        }
        catch (Exception e) {
            throw Lang.makeThrow("Error email format [%s]", str);
        }
        if (Strings.isBlank(this.account) || Strings.isBlank(this.host) || this.host.indexOf(46) < 0) {
            throw Lang.makeThrow("Error email format [%s]", str);
        }
    }

    public Email(String account, String host) {
        this.account = account;
        this.host = host;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int hashCode() {
        if (null == this.account) {
            return 0;
        }
        return this.account.hashCode();
    }

    public Email clone() throws CloneNotSupportedException {
        return new Email(this.account, this.host);
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!Email.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!this.account.equals(((Email)obj).account)) {
            return false;
        }
        return this.host.equals(((Email)obj).host);
    }

    public String toString() {
        return String.format("%s@%s", this.account, this.host);
    }
}

