/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.json.Json;
import org.nutz.lang.Each;
import org.nutz.lang.Invoking;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;

public class JsonRPC {
    public static final int ParseError = -32700;
    public static final int InvalidRequest = -32600;
    public static final int MethodNotFound = -32601;
    public static final int InvalidParams = -32602;
    public static final int InternalError = -32603;
    public static final int ServerError = -32000;
    public static final String Version = "2.0";

    public static NutMap invoke(final Object obj, Reader r) {
        Object req;
        NutMap resp = new NutMap();
        resp.setv("jsonrpc", Version);
        try {
            req = Json.fromJson(r);
        }
        catch (Exception e) {
            return resp.setv("error", JsonRPC.error(-32700, "Parse error", JsonRPC.E(e)));
        }
        if (req == null) {
            return resp.setv("error", JsonRPC.error(-32600, "Invalid Request", "json is null"));
        }
        if (req instanceof Iterable) {
            final ArrayList results = new ArrayList();
            Lang.each(req, new Each<Object>(){

                @Override
                public void invoke(int index, Object ele, int length) {
                    if (ele instanceof Map) {
                        results.add(JsonRPC.invoke(obj, new NutMap((Map)ele)));
                    } else {
                        NutMap _resp = new NutMap();
                        _resp.setv("jsonrpc", JsonRPC.Version).setv("error", JsonRPC.error(-32600, "Invalid Request", "not map or list"));
                        results.add(_resp);
                    }
                }
            });
            return resp.setv("result", results);
        }
        if (req instanceof Map) {
            return JsonRPC.invoke(obj, new NutMap((Map)req));
        }
        return resp.setv("error", JsonRPC.error(-32600, "Invalid Request", "not map or list"));
    }

    public static NutMap invoke(Object obj, NutMap req) {
        Invoking ing;
        NutMap resp = new NutMap();
        String version = req.getString("jsonrpc", Version);
        String id = req.getString("id");
        resp.setv("id", id);
        resp.setv("jsonrpc", version);
        String method = req.getString("method");
        if (Strings.isBlank(method)) {
            return resp.setv("error", JsonRPC.error(-32600, "Invalid Request", "method name is blank"));
        }
        List<Object> params = req.getList("params", Object.class, Collections.EMPTY_LIST);
        try {
            ing = Mirror.me(obj).getInvoking(method, params.toArray());
        }
        catch (Exception e) {
            return resp.setv("error", JsonRPC.error(-32601, "Method not found", JsonRPC.E(e)));
        }
        try {
            return resp.setv("result", ing.invoke(obj));
        }
        catch (Exception e) {
            return resp.setv("error", JsonRPC.error(-32000, e.getMessage(), JsonRPC.E(e)));
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            return resp.setv("error", JsonRPC.error(-32603, e.getMessage(), JsonRPC.E(e)));
        }
    }

    protected static NutMap error(int code, String message, Object data) {
        return new NutMap().setv("code", code).setv("message", message).setv("data", data);
    }

    protected static String E(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        e.printStackTrace(writer);
        return sw.toString();
    }

    public static <T> T mapper(Class<T> klass, final String endpoint, final String namespace, final int timeout) {
        return (T)Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                NutMap jreq = new NutMap();
                jreq.setv("jsonrpc", JsonRPC.Version).setv("id", R.UU32()).setv("method", method.getName());
                if (!Strings.isBlank(namespace)) {
                    jreq.put("namespace", namespace);
                }
                jreq.setv("params", args);
                Request req = Request.create(endpoint, Request.METHOD.POST);
                req.setData(Json.toJson(jreq));
                Response resp = Sender.create(req).setTimeout(timeout).send();
                if (resp.isOK()) {
                    if (method.getReturnType() == Void.class) {
                        return null;
                    }
                    return Json.fromJson(method.getGenericReturnType(), resp.getReader());
                }
                throw new RuntimeException("resp code=" + resp.getStatus());
            }
        });
    }
}

