/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.validate;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nutz.lang.util.NutMap;
import org.nutz.validate.NutValidateException;
import org.nutz.validate.NutValidator;
import org.nutz.validate.impl.DateRangeValidator;
import org.nutz.validate.impl.IntRangeValidator;
import org.nutz.validate.impl.MaxLengthValidator;
import org.nutz.validate.impl.MinLengthValidator;
import org.nutz.validate.impl.NotNullValidator;
import org.nutz.validate.impl.RegexValidator;
import org.nutz.validate.impl.TrimValidator;

public class NutValidate {
    private List<NutValidator> items = new LinkedList<NutValidator>();

    public NutValidate() {
    }

    public NutValidate(Map<String, Object> map) {
        this();
        this.items.clear();
        this.addAll(map);
        this.ready();
    }

    public NutValidate addAll(Map<String, Object> map) {
        NutMap m2 = NutMap.WRAP(map);
        for (String key : m2.keySet()) {
            if ("trim".equals(key)) {
                this.items.add(new TrimValidator());
                continue;
            }
            if ("intRange".equals(key)) {
                String str = m2.getString(key);
                this.items.add(new IntRangeValidator(str));
                continue;
            }
            if ("dateRange".equals(key)) {
                String str = m2.getString(key);
                this.items.add(new DateRangeValidator(str));
                continue;
            }
            if ("regex".equals(key)) {
                String str = m2.getString(key);
                this.items.add(new RegexValidator(str));
                continue;
            }
            if ("notNull".equals(key)) {
                this.items.add(new NotNullValidator());
                continue;
            }
            if ("maxLength".equals(key)) {
                int len = m2.getInt(key);
                this.items.add(new MaxLengthValidator(len));
                continue;
            }
            if (!"minLength".equals(key)) continue;
            int len = m2.getInt(key);
            this.items.add(new MinLengthValidator(len));
        }
        return this;
    }

    public NutValidate add(NutValidator ... nvs) {
        for (NutValidator nv : nvs) {
            this.items.add(nv);
        }
        return this;
    }

    public NutValidate ready() {
        Collections.sort(this.items, new Comparator<NutValidator>(){

            @Override
            public int compare(NutValidator v1, NutValidator v2) {
                return v1.order() - v2.order();
            }
        });
        return this;
    }

    public NutValidate reset() {
        this.items.clear();
        return this;
    }

    public Object check(Object val) throws NutValidateException {
        Object re = val;
        for (NutValidator nv : this.items) {
            re = nv.check(re);
        }
        return re;
    }
}

