/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.ExtensionFactory;
import org.apache.dubbo.common.extension.ExtensionLoader;

@Adaptive
public class AdaptiveExtensionFactory
implements ExtensionFactory {
    private final List<ExtensionFactory> factories;

    public AdaptiveExtensionFactory() {
        ExtensionLoader<ExtensionFactory> loader = ExtensionLoader.getExtensionLoader(ExtensionFactory.class);
        ArrayList<ExtensionFactory> list = new ArrayList<ExtensionFactory>();
        for (String name : loader.getSupportedExtensions()) {
            list.add(loader.getExtension(name));
        }
        this.factories = Collections.unmodifiableList(list);
    }

    @Override
    public <T> T getExtension(Class<T> type, String name) {
        for (ExtensionFactory factory : this.factories) {
            T extension = factory.getExtension(type, name);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }
}

