/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.bootstrap.builders.AbstractBuilder;

public class ModuleBuilder
extends AbstractBuilder<ModuleConfig, ModuleBuilder> {
    private String name;
    private String version;
    private String owner;
    private String organization;
    private List<RegistryConfig> registries;
    private MonitorConfig monitor;
    private Boolean isDefault;

    public ModuleBuilder name(String name) {
        this.name = name;
        return this.getThis();
    }

    public ModuleBuilder version(String version) {
        this.version = version;
        return this.getThis();
    }

    public ModuleBuilder owner(String owner) {
        this.owner = owner;
        return this.getThis();
    }

    public ModuleBuilder organization(String organization) {
        this.organization = organization;
        return this.getThis();
    }

    public ModuleBuilder addRegistries(List<? extends RegistryConfig> registries) {
        if (this.registries == null) {
            this.registries = new ArrayList<RegistryConfig>();
        }
        this.registries.addAll(registries);
        return this.getThis();
    }

    public ModuleBuilder addRegistry(RegistryConfig registry) {
        if (this.registries == null) {
            this.registries = new ArrayList<RegistryConfig>();
        }
        this.registries.add(registry);
        return this.getThis();
    }

    public ModuleBuilder monitor(MonitorConfig monitor) {
        this.monitor = monitor;
        return this.getThis();
    }

    public ModuleBuilder isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this.getThis();
    }

    @Override
    public ModuleConfig build() {
        ModuleConfig moduleConfig = new ModuleConfig();
        super.build(moduleConfig);
        moduleConfig.setDefault(this.isDefault);
        moduleConfig.setMonitor(this.monitor);
        moduleConfig.setName(this.name);
        moduleConfig.setOrganization(this.organization);
        moduleConfig.setOwner(this.owner);
        moduleConfig.setRegistries(this.registries);
        moduleConfig.setVersion(this.version);
        return moduleConfig;
    }

    @Override
    protected ModuleBuilder getThis() {
        return this;
    }
}

