/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.StringUtils;

public class Request {
    private static final AtomicLong INVOKE_ID = new AtomicLong(0L);
    private final long mId;
    private String mVersion;
    private boolean mTwoWay = true;
    private boolean mEvent = false;
    private boolean mBroken = false;
    private Object mData;

    public Request() {
        this.mId = Request.newId();
    }

    public Request(long id) {
        this.mId = id;
    }

    private static long newId() {
        return INVOKE_ID.getAndIncrement();
    }

    private static String safeToString(Object data) {
        String dataStr;
        if (data == null) {
            return null;
        }
        try {
            dataStr = data.toString();
        }
        catch (Throwable e) {
            dataStr = "<Fail toString of " + data.getClass() + ", cause: " + StringUtils.toString(e) + ">";
        }
        return dataStr;
    }

    public long getId() {
        return this.mId;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public boolean isTwoWay() {
        return this.mTwoWay;
    }

    public void setTwoWay(boolean twoWay) {
        this.mTwoWay = twoWay;
    }

    public boolean isEvent() {
        return this.mEvent;
    }

    public void setEvent(String event) {
        this.mEvent = true;
        this.mData = event;
    }

    public void setEvent(boolean mEvent) {
        this.mEvent = mEvent;
    }

    public boolean isBroken() {
        return this.mBroken;
    }

    public void setBroken(boolean mBroken) {
        this.mBroken = mBroken;
    }

    public Object getData() {
        return this.mData;
    }

    public void setData(Object msg) {
        this.mData = msg;
    }

    public boolean isHeartbeat() {
        return this.mEvent && CommonConstants.HEARTBEAT_EVENT == this.mData;
    }

    public void setHeartbeat(boolean isHeartbeat) {
        if (isHeartbeat) {
            this.setEvent(CommonConstants.HEARTBEAT_EVENT);
        }
    }

    public Request copy() {
        Request copy = new Request(this.mId);
        copy.mVersion = this.mVersion;
        copy.mTwoWay = this.mTwoWay;
        copy.mEvent = this.mEvent;
        copy.mBroken = this.mBroken;
        copy.mData = this.mData;
        return copy;
    }

    public String toString() {
        return "Request [id=" + this.mId + ", version=" + this.mVersion + ", twoway=" + this.mTwoWay + ", event=" + this.mEvent + ", broken=" + this.mBroken + ", data=" + (this.mData == this ? "this" : Request.safeToString(this.mData)) + "]";
    }
}

