/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.gem.BeanMappingGem;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.EnumMappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.ValueMappingOptions;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.spi.EnumTransformationStrategy;

public class ValueMappingMethod
extends MappingMethod {
    private final List<MappingEntry> valueMappings;
    private final String defaultTarget;
    private final String nullTarget;
    private final Type unexpectedValueMappingException;
    private final boolean overridden;

    private ValueMappingMethod(Method method, List<MappingEntry> enumMappings, String nullTarget, String defaultTarget, Type unexpectedValueMappingException, List<LifecycleCallbackMethodReference> beforeMappingMethods, List<LifecycleCallbackMethodReference> afterMappingMethods) {
        super(method, beforeMappingMethods, afterMappingMethods);
        this.valueMappings = enumMappings;
        this.nullTarget = nullTarget;
        this.defaultTarget = defaultTarget;
        this.unexpectedValueMappingException = unexpectedValueMappingException;
        this.overridden = method.overridesMethod();
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> importTypes = super.getImportTypes();
        if (this.unexpectedValueMappingException != null && !this.unexpectedValueMappingException.isJavaLangType()) {
            importTypes.addAll(this.unexpectedValueMappingException.getImportTypes());
        }
        return importTypes;
    }

    public List<MappingEntry> getValueMappings() {
        return this.valueMappings;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public String getNullTarget() {
        return this.nullTarget;
    }

    public Type getUnexpectedValueMappingException() {
        return this.unexpectedValueMappingException;
    }

    public Parameter getSourceParameter() {
        return Collections.first(this.getSourceParameters());
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public static class MappingEntry {
        private final String source;
        private final String target;

        MappingEntry(String source, String target) {
            this.source = source;
            this.target = !"<NULL>".equals(target) ? target : null;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    private static class ValueMappings {
        List<ValueMappingOptions> regularValueMappings = new ArrayList<ValueMappingOptions>();
        ValueMappingOptions defaultTarget = null;
        String defaultTargetValue = null;
        ValueMappingOptions nullTarget = null;
        String nullValueTarget = null;
        boolean hasMapAnyUnmapped = false;
        boolean hasMapAnyRemaining = false;
        boolean hasDefaultValue = false;
        boolean hasNullValue = false;

        ValueMappings(List<ValueMappingOptions> valueMappings) {
            for (ValueMappingOptions valueMapping : valueMappings) {
                if ("<ANY_REMAINING>".equals(valueMapping.getSource())) {
                    this.defaultTarget = valueMapping;
                    this.defaultTargetValue = this.getValue(this.defaultTarget);
                    this.hasDefaultValue = true;
                    this.hasMapAnyRemaining = true;
                    continue;
                }
                if ("<ANY_UNMAPPED>".equals(valueMapping.getSource())) {
                    this.defaultTarget = valueMapping;
                    this.defaultTargetValue = this.getValue(this.defaultTarget);
                    this.hasDefaultValue = true;
                    this.hasMapAnyUnmapped = true;
                    continue;
                }
                if ("<NULL>".equals(valueMapping.getSource())) {
                    this.nullTarget = valueMapping;
                    this.nullValueTarget = this.getValue(this.nullTarget);
                    this.hasNullValue = true;
                    continue;
                }
                this.regularValueMappings.add(valueMapping);
            }
        }

        String getValue(ValueMappingOptions valueMapping) {
            return "<NULL>".equals(valueMapping.getTarget()) ? null : valueMapping.getTarget();
        }
    }

    private static class EnumTransformationStrategyInvoker {
        private static final EnumTransformationStrategyInvoker DEFAULT = new EnumTransformationStrategyInvoker(null, null);
        private final EnumTransformationStrategy transformationStrategy;
        private final String configuration;

        private EnumTransformationStrategyInvoker(EnumTransformationStrategy transformationStrategy, String configuration) {
            this.transformationStrategy = transformationStrategy;
            this.configuration = configuration;
        }

        private String transform(String source) {
            if (this.transformationStrategy == null) {
                return source;
            }
            return this.transformationStrategy.transform(source, this.configuration);
        }
    }

    public static class Builder {
        private Method method;
        private MappingBuilderContext ctx;
        private ValueMappings valueMappings;
        private EnumMappingOptions enumMapping;
        private EnumTransformationStrategyInvoker enumTransformationInvoker;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder method(Method sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder valueMappings(List<ValueMappingOptions> valueMappings) {
            this.valueMappings = new ValueMappings(valueMappings);
            return this;
        }

        public Builder enumMapping(EnumMappingOptions enumMapping) {
            this.enumMapping = enumMapping;
            return this;
        }

        public ValueMappingMethod build() {
            if (!this.enumMapping.isValid()) {
                return null;
            }
            this.initializeEnumTransformationStrategy();
            ArrayList<MappingEntry> mappingEntries = new ArrayList<MappingEntry>();
            Type sourceType = Collections.first(this.method.getSourceParameters()).getType();
            Type targetType = this.method.getResultType();
            if (targetType.isEnumType() && this.valueMappings.nullTarget == null) {
                this.valueMappings.nullValueTarget = this.ctx.getEnumMappingStrategy().getDefaultNullEnumConstant(targetType.getTypeElement());
            }
            if (sourceType.isEnumType() && targetType.isEnumType()) {
                mappingEntries.addAll(this.enumToEnumMapping(this.method, sourceType, targetType));
            } else if (sourceType.isEnumType() && targetType.isString()) {
                mappingEntries.addAll(this.enumToStringMapping(this.method, sourceType));
            } else if (sourceType.isString() && targetType.isEnumType()) {
                mappingEntries.addAll(this.stringToEnumMapping(this.method, targetType));
            }
            SelectionParameters selectionParameters = this.getSelectionParameters(this.method, this.ctx.getTypeUtils());
            HashSet<String> existingVariables = new HashSet<String>(this.method.getParameterNames());
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, selectionParameters, this.ctx, existingVariables);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, selectionParameters, this.ctx, existingVariables);
            return new ValueMappingMethod(this.method, mappingEntries, this.valueMappings.nullValueTarget, this.valueMappings.defaultTargetValue, this.determineUnexpectedValueMappingException(), beforeMappingMethods, afterMappingMethods);
        }

        private void initializeEnumTransformationStrategy() {
            if (!this.enumMapping.hasNameTransformationStrategy()) {
                this.enumTransformationInvoker = EnumTransformationStrategyInvoker.DEFAULT;
            } else {
                String nameTransformationStrategy;
                Map<String, EnumTransformationStrategy> enumTransformationStrategies = this.ctx.getEnumTransformationStrategies();
                if (enumTransformationStrategies.containsKey(nameTransformationStrategy = this.enumMapping.getNameTransformationStrategy())) {
                    this.enumTransformationInvoker = new EnumTransformationStrategyInvoker(enumTransformationStrategies.get(nameTransformationStrategy), this.enumMapping.getNameTransformationConfiguration());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private List<MappingEntry> enumToEnumMapping(Method method, Type sourceType, Type targetType) {
            boolean targetErrorOccurred;
            ArrayList<MappingEntry> mappings = new ArrayList<MappingEntry>();
            ArrayList<String> unmappedSourceConstants = new ArrayList<String>(sourceType.getEnumConstants());
            boolean sourceErrorOccurred = !this.reportErrorIfMappedSourceEnumConstantsDontExist(method, sourceType);
            boolean bl = targetErrorOccurred = !this.reportErrorIfMappedTargetEnumConstantsDontExist(method, targetType);
            if (sourceErrorOccurred || targetErrorOccurred) {
                return mappings;
            }
            for (ValueMappingOptions valueMapping : this.valueMappings.regularValueMappings) {
                mappings.add(new MappingEntry(valueMapping.getSource(), valueMapping.getTarget()));
                unmappedSourceConstants.remove(valueMapping.getSource());
            }
            if (!this.valueMappings.hasMapAnyUnmapped) {
                LinkedHashMap<String, String> targetConstants = new LinkedHashMap<String, String>();
                boolean enumMappingInverse = this.enumMapping.isInverse();
                TypeElement targetTypeElement = method.getReturnType().getTypeElement();
                for (String string : method.getReturnType().getEnumConstants()) {
                    String targetNameEnum = this.getEnumConstant(targetTypeElement, string);
                    if (enumMappingInverse) {
                        targetConstants.put(this.enumTransformationInvoker.transform(targetNameEnum), string);
                        continue;
                    }
                    targetConstants.put(targetNameEnum, string);
                }
                TypeElement sourceTypeElement = sourceType.getTypeElement();
                for (String sourceConstant : new ArrayList<String>(unmappedSourceConstants)) {
                    String sourceNameConstant = this.getEnumConstant(sourceTypeElement, sourceConstant);
                    String targetConstant = !enumMappingInverse ? this.enumTransformationInvoker.transform(sourceNameConstant) : sourceNameConstant;
                    if (targetConstants.containsKey(targetConstant)) {
                        mappings.add(new MappingEntry(sourceConstant, (String)targetConstants.get(targetConstant)));
                        unmappedSourceConstants.remove(sourceConstant);
                        continue;
                    }
                    if (!"<NULL>".equals(targetConstant)) continue;
                    mappings.add(new MappingEntry(sourceConstant, null));
                    unmappedSourceConstants.remove(sourceConstant);
                }
                if (this.valueMappings.defaultTarget == null && !unmappedSourceConstants.isEmpty()) {
                    void var12_17;
                    String string = "source";
                    String targetErrorMessage = "target";
                    if (method instanceof ForgedMethod && ((ForgedMethod)method).getHistory() != null) {
                        ForgedMethodHistory history = ((ForgedMethod)method).getHistory();
                        String string2 = history.createSourcePropertyErrorMessage();
                        targetErrorMessage = "\"" + history.getTargetType().describe() + " " + history.createTargetPropertyName() + "\"";
                    }
                    this.ctx.getMessager().printMessage((Element)method.getExecutable(), Message.VALUEMAPPING_UNMAPPED_SOURCES, var12_17, targetErrorMessage, Strings.join(unmappedSourceConstants, ", "));
                }
            }
            return mappings;
        }

        private List<MappingEntry> enumToStringMapping(Method method, Type sourceType) {
            boolean anyRemainingUsedError;
            ArrayList<MappingEntry> mappings = new ArrayList<MappingEntry>();
            ArrayList<String> unmappedSourceConstants = new ArrayList<String>(sourceType.getEnumConstants());
            boolean sourceErrorOccurred = !this.reportErrorIfMappedSourceEnumConstantsDontExist(method, sourceType);
            boolean bl = anyRemainingUsedError = !this.reportErrorIfSourceEnumConstantsContainsAnyRemaining(method);
            if (sourceErrorOccurred || anyRemainingUsedError) {
                return mappings;
            }
            for (ValueMappingOptions valueMapping : this.valueMappings.regularValueMappings) {
                mappings.add(new MappingEntry(valueMapping.getSource(), valueMapping.getTarget()));
                unmappedSourceConstants.remove(valueMapping.getSource());
            }
            if (!this.valueMappings.hasMapAnyUnmapped) {
                TypeElement sourceTypeElement = sourceType.getTypeElement();
                for (String sourceConstant : unmappedSourceConstants) {
                    String sourceNameConstant = this.getEnumConstant(sourceTypeElement, sourceConstant);
                    String targetConstant = this.enumTransformationInvoker.transform(sourceNameConstant);
                    mappings.add(new MappingEntry(sourceConstant, targetConstant));
                }
            }
            return mappings;
        }

        private List<MappingEntry> stringToEnumMapping(Method method, Type targetType) {
            boolean mandatoryMissing;
            ArrayList<MappingEntry> mappings = new ArrayList<MappingEntry>();
            ArrayList<String> unmappedSourceConstants = new ArrayList<String>(targetType.getEnumConstants());
            boolean sourceErrorOccurred = !this.reportErrorIfMappedTargetEnumConstantsDontExist(method, targetType);
            boolean bl = mandatoryMissing = !this.reportErrorIfAnyRemainingOrAnyUnMappedMissing(method);
            if (sourceErrorOccurred || mandatoryMissing) {
                return mappings;
            }
            LinkedHashSet<String> mappedSources = new LinkedHashSet<String>();
            for (ValueMappingOptions valueMapping : this.valueMappings.regularValueMappings) {
                mappedSources.add(valueMapping.getSource());
                mappings.add(new MappingEntry(valueMapping.getSource(), valueMapping.getTarget()));
                unmappedSourceConstants.remove(valueMapping.getSource());
            }
            if (!this.valueMappings.hasMapAnyUnmapped) {
                mappedSources.add("<NULL>");
                TypeElement targetTypeElement = targetType.getTypeElement();
                for (String sourceConstant : unmappedSourceConstants) {
                    String sourceNameConstant = this.getEnumConstant(targetTypeElement, sourceConstant);
                    String stringConstant = this.enumTransformationInvoker.transform(sourceNameConstant);
                    if (mappedSources.contains(stringConstant)) continue;
                    mappings.add(new MappingEntry(stringConstant, sourceConstant));
                }
            }
            return mappings;
        }

        private String getEnumConstant(TypeElement typeElement, String enumConstant) {
            return this.ctx.getEnumMappingStrategy().getEnumConstant(typeElement, enumConstant);
        }

        private SelectionParameters getSelectionParameters(Method method, Types typeUtils) {
            BeanMappingGem beanMapping = BeanMappingGem.instanceOn(method.getExecutable());
            if (beanMapping != null) {
                List<TypeMirror> qualifiers = beanMapping.qualifiedBy().get();
                List<String> qualifyingNames = beanMapping.qualifiedByName().get();
                TypeMirror resultType = beanMapping.resultType().get();
                return new SelectionParameters(qualifiers, qualifyingNames, resultType, typeUtils);
            }
            return null;
        }

        private boolean reportErrorIfMappedSourceEnumConstantsDontExist(Method method, Type sourceType) {
            List<String> sourceEnumConstants = sourceType.getEnumConstants();
            boolean foundIncorrectMapping = false;
            for (ValueMappingOptions mappedConstant : this.valueMappings.regularValueMappings) {
                if (sourceEnumConstants.contains(mappedConstant.getSource())) continue;
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getSourceAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, mappedConstant.getSource(), sourceType);
                foundIncorrectMapping = true;
            }
            return !foundIncorrectMapping;
        }

        private boolean reportErrorIfSourceEnumConstantsContainsAnyRemaining(Method method) {
            boolean foundIncorrectMapping = false;
            if (this.valueMappings.hasMapAnyRemaining) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), this.valueMappings.defaultTarget.getMirror(), this.valueMappings.defaultTarget.getSourceAnnotationValue(), Message.VALUEMAPPING_ANY_REMAINING_FOR_NON_ENUM, method.getResultType());
                foundIncorrectMapping = true;
            }
            return !foundIncorrectMapping;
        }

        private boolean reportErrorIfAnyRemainingOrAnyUnMappedMissing(Method method) {
            boolean foundIncorrectMapping = false;
            if (!this.valueMappings.hasMapAnyUnmapped && !this.valueMappings.hasMapAnyRemaining) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), Message.VALUEMAPPING_ANY_REMAINING_OR_UNMAPPED_MISSING, new Object[0]);
                foundIncorrectMapping = true;
            }
            return !foundIncorrectMapping;
        }

        private boolean reportErrorIfMappedTargetEnumConstantsDontExist(Method method, Type targetType) {
            List<String> targetEnumConstants = targetType.getEnumConstants();
            boolean foundIncorrectMapping = false;
            for (ValueMappingOptions mappedConstant : this.valueMappings.regularValueMappings) {
                if ("<NULL>".equals(mappedConstant.getTarget()) || targetEnumConstants.contains(mappedConstant.getTarget())) continue;
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getTargetAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, mappedConstant.getTarget(), method.getReturnType());
                foundIncorrectMapping = true;
            }
            if (this.valueMappings.defaultTarget != null && !"<NULL>".equals(this.valueMappings.defaultTarget.getTarget()) && !targetEnumConstants.contains(this.valueMappings.defaultTarget.getTarget())) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), this.valueMappings.defaultTarget.getMirror(), this.valueMappings.defaultTarget.getTargetAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, this.valueMappings.defaultTarget.getTarget(), method.getReturnType());
                foundIncorrectMapping = true;
            }
            if (this.valueMappings.nullTarget != null && "<NULL>".equals(this.valueMappings.nullTarget.getTarget()) && !targetEnumConstants.contains(this.valueMappings.nullTarget.getTarget())) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), this.valueMappings.nullTarget.getMirror(), this.valueMappings.nullTarget.getTargetAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, this.valueMappings.nullTarget.getTarget(), method.getReturnType());
                foundIncorrectMapping = true;
            } else if (this.valueMappings.nullTarget == null && this.valueMappings.nullValueTarget != null && !targetEnumConstants.contains(this.valueMappings.nullValueTarget)) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT_FROM_SPI, this.valueMappings.nullValueTarget, method.getReturnType(), this.ctx.getEnumMappingStrategy());
            }
            return !foundIncorrectMapping;
        }

        private Type determineUnexpectedValueMappingException() {
            if (!this.valueMappings.hasDefaultValue) {
                TypeMirror unexpectedValueMappingException = this.enumMapping.getUnexpectedValueMappingException();
                if (unexpectedValueMappingException != null) {
                    return this.ctx.getTypeFactory().getType(unexpectedValueMappingException);
                }
                return this.ctx.getTypeFactory().getType(this.ctx.getEnumMappingStrategy().getUnexpectedValueMappingExceptionType());
            }
            return null;
        }
    }
}

