/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.Impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.ozhera.prometheus.agent.Impl.BaseDao;
import org.apache.ozhera.prometheus.agent.entity.RuleAlertEntity;
import org.apache.ozhera.prometheus.agent.enums.RuleAlertStatusEnum;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.springframework.stereotype.Repository;

@Repository
public class RuleAlertDao
extends BaseDao {
    public SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Long CreateRuleAlert(RuleAlertEntity entity) {
        Long id = ((RuleAlertEntity)this.dao.insert((Object)entity)).getId();
        return id;
    }

    public String UpdateRuleAlert(String id, RuleAlertEntity entity) {
        try {
            int update = this.dao.updateIgnoreNull((Object)entity);
            return String.valueOf(update);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public int DeleteRuleAlert(String id) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("id", (Object)id).andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        RuleAlertEntity dbRes = (RuleAlertEntity)this.dao.fetch(RuleAlertEntity.class, (Condition)cnd);
        if (dbRes == null) {
            return -1;
        }
        dbRes.setDeletedBy("xxx");
        dbRes.setUpdatedTime(new Date());
        dbRes.setDeletedTime(new Date());
        dbRes.setStatus(RuleAlertStatusEnum.DELETE.getDesc());
        int updateRes = this.dao.updateIgnoreNull((Object)dbRes);
        return updateRes;
    }

    public RuleAlertEntity GetRuleAlert(String id) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("id", (Object)id).andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        RuleAlertEntity dbRes = (RuleAlertEntity)this.dao.fetch(RuleAlertEntity.class, (Condition)cnd);
        return dbRes;
    }

    public RuleAlertEntity GetRuleAlertByAlertName(String name) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("name", (Object)name).andIsNull("deleted_time").andEquals("enabled", (Object)1);
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        RuleAlertEntity dbRes = (RuleAlertEntity)this.dao.fetch(RuleAlertEntity.class, (Condition)cnd);
        return dbRes;
    }

    public String[] GetRuleAlertAtPeople(String name) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("name", (Object)name).andIsNull("deleted_time").andEquals("enabled", (Object)1);
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        RuleAlertEntity dbRes = (RuleAlertEntity)this.dao.fetch(RuleAlertEntity.class, (Condition)cnd);
        if (dbRes == null) {
            return null;
        }
        String[] peoples = dbRes.getAlertAtPeople().split(",");
        return peoples;
    }

    public List<RuleAlertEntity> GetRuleAlertList(Integer pageSize, Integer pageNo) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        List datas = this.dao.query(RuleAlertEntity.class, (Condition)cnd.desc("id"), this.buildPager(pageNo, pageSize));
        return datas;
    }

    public Integer CountRuleAlert() {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andIsNull("deleted_time");
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        int count = this.dao.count(RuleAlertEntity.class, (Condition)cnd);
        return count;
    }

    public List<RuleAlertEntity> GetAllRuleAlertList() {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andIsNull("deleted_time").andEquals("enabled", (Object)1);
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        List datas = this.dao.query(RuleAlertEntity.class, (Condition)cnd.desc("id"));
        return datas;
    }

    public List<RuleAlertEntity> GetAllCloudRuleAlertList(String status) {
        SqlExpressionGroup sqlExpr = new SqlExpressionGroup();
        sqlExpr = status.equals(RuleAlertStatusEnum.ALL.getDesc()) ? Cnd.cri().where().andNotEquals("status", (Object)RuleAlertStatusEnum.DONE.getDesc()) : Cnd.cri().where().andIsNull("deleted_time").andEquals("enabled", (Object)1);
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        List datas = this.dao.query(RuleAlertEntity.class, (Condition)cnd.desc("id"));
        return datas;
    }

    public int UpdateRuleAlertDeleteToDone(String alertName) {
        SqlExpressionGroup sqlExpr = Cnd.cri().where().andEquals("name", (Object)alertName).andEquals("status", (Object)RuleAlertStatusEnum.DELETE.getDesc());
        Cnd cnd = Cnd.where((SqlExpression)sqlExpr);
        try {
            RuleAlertEntity data = (RuleAlertEntity)this.dao.fetch(RuleAlertEntity.class, (Condition)cnd);
            data.setStatus(RuleAlertStatusEnum.DONE.getDesc());
            int update = this.dao.updateIgnoreNull((Object)data);
            return update;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

