/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.api.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.model.GrafanaTemplate;
import org.apache.ozhera.monitor.service.api.GrafanaServiceExtension;
import org.apache.ozhera.monitor.service.model.GrafanaResponse;
import org.apache.ozhera.monitor.service.model.MutiGrafanaResponse;
import org.apache.ozhera.monitor.utils.FreeMarkerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class GrafanaServiceExtensionImpl
implements GrafanaServiceExtension {
    private static final Logger log = LoggerFactory.getLogger(GrafanaServiceExtensionImpl.class);
    private final Map<String, String> grafanaFolderData = new HashMap<String, String>();
    private static final String ID = "id";
    private static final String UID = "uid";
    private final Map<String, String> ContainerAndHostUrl = new HashMap<String, String>();
    private static final String CONTAINER_URL = "containerUrl";
    private static final String HOST_URL = "hostUrl";
    private static final String HERA = "hera";
    private static final Integer[] PANEL_IDS = new Integer[]{110, 148, 152, 112, 116, 118, 150, 122, 120, 126, 124, 130, 128, 132, 134, 136, 138, 140, 142, 144, 146, 52, 56, 58, 60, 66, 95, 96, 50, 82, 68, 78, 74, 76, 102, 104, 106, 146, 159, 163, 168, 169, 170, 171, 172, 173, 174};
    private static final int DIY_FOLDER_ID = 159;
    private final Gson gson = new Gson();
    @NacosValue(value="${grafana.prometheus.datasource}", autoRefreshed=true)
    private String dataSource;
    @NacosValue(value="${grafana.address}", autoRefreshed=true)
    private String grafanaAddress;
    @NacosValue(value="${grafana.domain}", autoRefreshed=true)
    private String grafanaDomain;
    @NacosValue(value="${grafana.api.key}", autoRefreshed=true)
    private String grafanaApiKey;
    @NacosValue(value="${grafana.folder.id}", autoRefreshed=true)
    private String grafanaFolderId;
    @NacosValue(value="${grafana.folder.uid}", autoRefreshed=true)
    private String grafanaFolderUid;
    @NacosValue(value="${grafana.version.url}", autoRefreshed=true)
    private String grafanaVersionUrl;
    @NacosValue(value="${grafana.checkDashboard.url}", autoRefreshed=true)
    private String grafanaCheckUrl;
    @NacosValue(value="${grafana.container.url}", autoRefreshed=true)
    private String grafanaContainerUrl;
    @NacosValue(value="${grafana.host.url}", autoRefreshed=true)
    private String grafanaHostUrl;
    @NacosValue(value="${grafana.createDashboard.url}", autoRefreshed=true)
    private String getGrafanaCreateDashboardUrl;
    @NacosValue(value="${prometheusUid}", autoRefreshed=true)
    private String prometheusUid;

    @Override
    public void setFolderData(String area) {
        log.info("grafana setFolderData begin");
        switch (area) {
            case "Hera": {
                this.grafanaFolderData.put(ID, this.grafanaFolderId);
                this.grafanaFolderData.put(UID, this.grafanaFolderUid);
                break;
            }
            default: {
                this.grafanaFolderData.put(ID, this.grafanaFolderId);
                this.grafanaFolderData.put(UID, this.grafanaFolderUid);
            }
        }
    }

    @Override
    public void setContainerAndHostUrl(String area) {
        switch (area) {
            case "Hera": {
                this.ContainerAndHostUrl.put(CONTAINER_URL, this.grafanaDomain + this.grafanaContainerUrl + "${__data.fields.ip.text}&var-pod=${__data.fields.pod.text}");
                this.ContainerAndHostUrl.put(HOST_URL, this.grafanaDomain + this.grafanaHostUrl + "${__data.fields.ip.text}");
                break;
            }
            default: {
                this.ContainerAndHostUrl.put(CONTAINER_URL, this.grafanaDomain + this.grafanaContainerUrl + "${__data.fields.ip.text}&var-pod=${__data.fields.pod.text}");
                this.ContainerAndHostUrl.put(HOST_URL, this.grafanaDomain + this.grafanaHostUrl + "${__data.fields.ip.text}");
            }
        }
    }

    @Override
    public MutiGrafanaResponse requestGrafanaTemplate(String group, String title, String area, GrafanaTemplate template, List<String> funcList) {
        log.info("requestGrafanaTemplate group {},title {}, area {}", new Object[]{group, title, area});
        area = "Hera";
        MutiGrafanaResponse mutiGrafanaResponse = new MutiGrafanaResponse();
        try {
            Map<String, String> map = this.beforeRequestGrafana(area, title);
            String containerName = map.get("containerName");
            title = map.get("title");
            String tmp = this.innerRequestGrafanaStr(area, title, containerName, group, template, title);
            ArrayList<GrafanaResponse> grafanaResponseList = new ArrayList<GrafanaResponse>();
            GrafanaResponse grafanaResponse = (GrafanaResponse)new Gson().fromJson(tmp, GrafanaResponse.class);
            grafanaResponseList.add(grafanaResponse);
            mutiGrafanaResponse.setData(grafanaResponseList);
            mutiGrafanaResponse.setMessage("success");
            mutiGrafanaResponse.setCode(0);
            mutiGrafanaResponse.setUrl(grafanaResponse.getUrl());
        }
        catch (Exception e) {
            log.error("requestGrafanaTemplate error", (Throwable)e);
            mutiGrafanaResponse.setMessage(e.getMessage());
            mutiGrafanaResponse.setCode(-1);
        }
        return mutiGrafanaResponse;
    }

    @Override
    public String innerRequestGrafanaStr(String area, String title, String containerName, String group, GrafanaTemplate template, String application) {
        String folderId = this.grafanaFolderData.get(ID);
        String folderUid = this.grafanaFolderData.get(UID);
        String grafanaUrl = this.grafanaAddress;
        String grafanaApiKey = this.grafanaApiKey;
        if (grafanaUrl == null || grafanaApiKey == null) {
            log.error("Incoming environment exception, server is {} url is {} ", (Object)title, (Object)grafanaUrl);
        }
        Map<String, Object> map = this.getTemplateVariables(folderId, group, title, folderUid, grafanaUrl, containerName, area, application);
        try {
            String temp = template.getTemplate();
            String data = FreeMarkerUtil.freemarkerProcess(map, (String)template.getTemplate());
            URL url = new URL(grafanaUrl + this.getGrafanaCreateDashboardUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Object out = null;
            conn.setRequestProperty("Expect", "");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestProperty("Authorization", "Bearer " + grafanaApiKey);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.connect();
            BufferedWriter out1 = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), "UTF-8"));
            out1.write(data);
            out1.flush();
            out1.close();
            String finalGrafanaStr = "";
            if (conn.getResponseCode() == 412) {
                log.info("requestGrafana panel already created,second request begin appName:{}", (Object)title);
                conn.disconnect();
                Object checkUrl = "";
                String uid = title;
                int len = title.length();
                if (len > 40) {
                    uid = title.substring(0, 40);
                }
                checkUrl = grafanaUrl + this.grafanaCheckUrl + uid;
                String finalData = this.getFinalData(data, (String)checkUrl, grafanaApiKey, "GET", title, template.getPanelIdList(), false, null);
                finalGrafanaStr = this.innerRequestGrafana(finalData, grafanaUrl + this.getGrafanaCreateDashboardUrl, grafanaApiKey, "POST");
            } else {
                InputStream is = conn.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String finalStr = "";
                String str = "";
                while ((str = br.readLine()) != null) {
                    finalStr = new String(str.getBytes(), "UTF-8");
                }
                is.close();
                conn.disconnect();
                finalGrafanaStr = finalStr;
            }
            String dashboardId = this.isGrafanaDataJson(finalGrafanaStr);
            if (StringUtils.isEmpty((CharSequence)dashboardId)) {
                return finalGrafanaStr;
            }
            String version = this.getDashboardLastVersion(dashboardId);
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(finalGrafanaStr, JsonObject.class);
            jsonObject.addProperty("mimonitor_version", version);
            return jsonObject.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public Map<String, Object> getTemplateVariables(String folderId, String group, String title, String folderUid, String grafanaUrl, String containerName, String area, String application) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("env", group);
        map.put("serviceName", HERA);
        map.put("title", title);
        map.put("folderId", folderId);
        map.put("folderUid", folderUid);
        map.put("dataSource", this.dataSource);
        map.put("grafanaUrl", grafanaUrl);
        map.put(CONTAINER_URL, this.ContainerAndHostUrl.get(CONTAINER_URL));
        map.put(HOST_URL, this.ContainerAndHostUrl.get(HOST_URL));
        map.put("containerName", containerName);
        map.put("application", application);
        map.put("prometheusUid", this.prometheusUid);
        int len = title.length();
        if (len > 40) {
            map.put(UID, title.substring(0, 40));
        } else {
            map.put(UID, title);
        }
        map.put("jaeger_error_list_url", "x");
        log.info("grafana.getTemplateVariables map:{}", (Object)this.gson.toJson(map));
        return map;
    }

    @Override
    public String getFinalData(String data, String url, String apiKey, String method, String title, String panelIdList, boolean isFaas, String originTitle) {
        String pastData = this.innerRequestGrafana("", url, apiKey, method);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(data, JsonObject.class);
        JsonObject dashboard = jsonObject.get("dashboard").getAsJsonObject();
        jsonObject.addProperty("overwrite", Boolean.valueOf(true));
        JsonArray panels = dashboard.getAsJsonArray("panels");
        int diyPanelGirdPosY = 0;
        for (JsonElement panel : panels) {
            JsonObject p = panel.getAsJsonObject();
            if (p.get(ID).getAsInt() != 159) continue;
            JsonObject py = p.get("gridPos").getAsJsonObject();
            diyPanelGirdPosY = py.get("y").getAsInt();
        }
        this.getCustomPanels(pastData, panels, diyPanelGirdPosY, title, panelIdList);
        return jsonObject.toString();
    }

    @Override
    public String getDashboardLastVersion(String dashboardId) {
        String url = this.grafanaAddress + this.grafanaVersionUrl;
        String finalUrl = url.replace("{dashboard_id}", dashboardId);
        String versionJsonData = this.innerRequestGrafana(null, finalUrl, this.grafanaApiKey, "GET");
        try {
            JsonArray jsonArray = (JsonArray)this.gson.fromJson(versionJsonData, JsonArray.class);
            String version = jsonArray.get(0).getAsJsonObject().get("message").getAsString();
            return version;
        }
        catch (Exception e) {
            log.error("getDashboardLastVersion err :{}, returnData : {}", (Object)e.toString(), (Object)versionJsonData);
            return "";
        }
    }

    @Override
    public String requestGrafana(String serverType, String appName, String area) {
        return "";
    }

    @Override
    public Map<String, String> beforeRequestGrafana(String area, String title) {
        this.setFolderData(area);
        this.setContainerAndHostUrl(area);
        String containerName = "";
        if (title.split("_").length < 2) {
            log.error("Wrong title parameter passed in {}", (Object)title);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (title.contains("-")) {
            containerName = title.split("_", 2)[1];
            title = title.replace("-", "_");
        } else {
            containerName = title.split("_", 2)[1];
        }
        map.put("title", title);
        map.put("containerName", containerName);
        return map;
    }

    @Override
    public String innerRequestGrafana(String data, String url, String apiKey, String method) {
        try {
            URL requestUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)requestUrl.openConnection();
            Object out = null;
            conn.setRequestProperty("Expect", "");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestProperty("Authorization", "Bearer " + apiKey);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod(method);
            conn.connect();
            if ("POST".equals(method)) {
                BufferedWriter out1 = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), "UTF-8"));
                out1.write(data);
                out1.flush();
                out1.close();
            }
            InputStream is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String finalStr = "";
            String str = "";
            while ((str = br.readLine()) != null) {
                finalStr = new String(str.getBytes(), "UTF-8");
            }
            is.close();
            conn.disconnect();
            log.info("innerRequestGrafana param url:{},apiKey:{},method:{}", new Object[]{url, apiKey, method});
            return finalStr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @Override
    public void getCustomPanels(String grafanaStr, JsonArray basicPanels, int basicDiyPanelGirdPosY, String title, String panelIdList) {
        List<Integer> templatePanelIds;
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(grafanaStr, JsonObject.class);
        JsonObject dashboard = jsonObject.get("dashboard").getAsJsonObject();
        JsonArray panels = dashboard.getAsJsonArray("panels");
        if (StringUtils.isBlank((CharSequence)panelIdList)) {
            templatePanelIds = Arrays.asList(PANEL_IDS);
        } else {
            String[] split = panelIdList.split(",");
            int[] array = Arrays.stream(split).mapToInt(Integer::parseInt).toArray();
            templatePanelIds = Arrays.stream(array).boxed().collect(Collectors.toList());
        }
        int diyPanelGirdPosY = 0;
        block6: for (JsonElement panel : panels) {
            JsonObject p = panel.getAsJsonObject();
            if (p.get(ID).getAsInt() == 159) {
                Object py = p.get("gridPos").getAsJsonObject();
                diyPanelGirdPosY = py.get("y").getAsInt();
            }
            switch (p.get("type").getAsString()) {
                case "row": {
                    JsonArray panels2 = p.get("panels").getAsJsonArray();
                    if (null == panels2 || panels2.size() == 0) continue block6;
                    for (JsonElement panel2 : panels2) {
                        Integer id;
                        JsonObject p2 = panel2.getAsJsonObject();
                        if (!"graph".equals(p2.get("type").getAsString()) || templatePanelIds.contains(id = Integer.valueOf(p2.get(ID).getAsInt()))) continue;
                        result.add(p2);
                    }
                    continue block6;
                }
                default: {
                    Integer defaultId = p.get(ID).getAsInt();
                    if (templatePanelIds.contains(defaultId)) continue block6;
                    result.add(p);
                }
            }
        }
        if (diyPanelGirdPosY == 0) {
            log.error("Get the custom directory location as 0,server is {}", (Object)title);
        }
        for (JsonObject diyPanel : result) {
            JsonObject girdPos = diyPanel.get("gridPos").getAsJsonObject();
            int finalGirdPosY = basicDiyPanelGirdPosY + Math.abs(girdPos.get("y").getAsInt() - diyPanelGirdPosY);
            girdPos.addProperty("y", (Number)finalGirdPosY);
            basicPanels.add((JsonElement)diyPanel);
        }
    }

    @Override
    public String isGrafanaDataJson(String jobJson) {
        try {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(jobJson, JsonObject.class);
            String id = jsonObject.get(ID).getAsString();
            String status = jsonObject.get("status").getAsString();
            if ("success".equals(status)) {
                return id;
            }
        }
        catch (Exception e) {
            log.error("create grafana dashboard err: {},param is: {}", (Object)e.toString(), (Object)jobJson);
            return "";
        }
        return "";
    }
}

