/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.prometheus;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.GrafanaTemplateDao;
import org.apache.ozhera.monitor.dao.model.GrafanaTemplate;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.CreateTemplateParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrafanaTemplateService {
    private static final Logger log = LoggerFactory.getLogger(GrafanaTemplateService.class);
    @Autowired
    GrafanaTemplateDao grafanaTemplateDao;
    private final Gson gson = new Gson();

    public Result createGrafanaTemplate(CreateTemplateParam param) {
        if (this.grafanaTemplateDao.fetchOneByName(param.getName()) != null) {
            return Result.fail((ErrorCode)ErrorCode.REPEAT_ADD_PROJECT);
        }
        GrafanaTemplate template = new GrafanaTemplate();
        template.setTemplate(param.getTemplate());
        template.setAppType(param.getAppType());
        template.setLanguage(param.getLanguage());
        template.setPlatform(param.getPlatform());
        template.setName(param.getName());
        template.setUrlParam(param.getUrlParam());
        template.setPanelIdList(param.getPanelIdList().trim());
        template.setDeleted(false);
        int dbResult = this.grafanaTemplateDao.insert(template);
        log.info("GrafanaTemplateService.createGrafanaTemplate request : {},dbResult: {}", (Object)param.getName(), (Object)dbResult);
        return Result.success((Object)dbResult);
    }

    public Result deleteGrafanaTemplate(int id) {
        if (this.grafanaTemplateDao.fetchById(id) == null) {
            return Result.fail((ErrorCode)ErrorCode.NO_DATA_FOUND);
        }
        int result = this.grafanaTemplateDao.delete(id);
        log.info("GrafanaTemplateService.deleteGrafanaTemplate id : {},dbResult: {}", (Object)id, (Object)result);
        return Result.success((Object)result);
    }

    public Result getGrafanaTemplate(int id) {
        GrafanaTemplate grafanaTemplate = this.grafanaTemplateDao.fetchById(id);
        log.info("GrafanaTemplateService.getGrafanaTemplate id : {}", (Object)id);
        return Result.success((Object)grafanaTemplate);
    }

    public Result listGrafanaTemplate(int pageSize, int pageNo) {
        PageData<List<GrafanaTemplate>> pd = new PageData<List<GrafanaTemplate>>();
        pd.setPage(pageNo);
        pd.setPageSize(pageSize);
        pd.setTotal(this.grafanaTemplateDao.getTotal());
        pd.setList(this.grafanaTemplateDao.list(pageSize, pageNo));
        log.info("GrafanaTemplateService.listGrafanaTemplate pageSize:{} pageNo: {}", (Object)pageSize, (Object)pageNo);
        return Result.success(pd);
    }

    public Result updateGrafanaTemplate(CreateTemplateParam param) {
        GrafanaTemplate grafanaTemplate = this.grafanaTemplateDao.fetchById(param.getId().intValue());
        if (grafanaTemplate == null) {
            return Result.fail((ErrorCode)ErrorCode.NO_DATA_FOUND);
        }
        grafanaTemplate.setTemplate(param.getTemplate());
        grafanaTemplate.setAppType(param.getAppType());
        grafanaTemplate.setLanguage(param.getLanguage());
        grafanaTemplate.setPlatform(param.getPlatform());
        grafanaTemplate.setName(param.getName());
        grafanaTemplate.setUrlParam(param.getUrlParam());
        grafanaTemplate.setId(param.getId().intValue());
        grafanaTemplate.setPanelIdList(param.getPanelIdList().trim());
        int dbResult = this.grafanaTemplateDao.update(grafanaTemplate);
        log.info("GrafanaTemplateService.updateGrafanaTemplate request : {},dbResult: {}", (Object)param, (Object)dbResult);
        return Result.success((Object)dbResult);
    }

    private String checkTemplateJson(String jobJson) {
        try {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(jobJson, JsonObject.class);
            String panels = jsonObject.get("panels").getAsString();
            String uid = jsonObject.get("uid").getAsString();
            String version = jsonObject.get("version").getAsString();
            if (StringUtils.isEmpty((CharSequence)panels) || StringUtils.isEmpty((CharSequence)uid) || StringUtils.isEmpty((CharSequence)version)) {
                return "Missing some request parameters";
            }
            return "ok";
        }
        catch (Exception e) {
            String errStr = "GrafanaTemplateService templateJson not right, error is: " + String.valueOf(e);
            log.error(errStr);
            return errStr;
        }
    }
}

