/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.logging;

import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.logging.AbstractLogFactory;
import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.LogException;
import org.mybatis.generator.logging.commons.JakartaCommonsLoggingLogFactory;
import org.mybatis.generator.logging.jdk14.Jdk14LoggingLogFactory;
import org.mybatis.generator.logging.log4j.Log4jLoggingLogFactory;
import org.mybatis.generator.logging.log4j2.Log4j2LoggingLogFactory;
import org.mybatis.generator.logging.nologging.NoLoggingLogFactory;
import org.mybatis.generator.logging.slf4j.Slf4jLoggingLogFactory;

public class LogFactory {
    private static AbstractLogFactory logFactory;
    public static String MARKER;

    public static Log getLog(Class<?> clazz) {
        try {
            return logFactory.getLog(clazz);
        }
        catch (Throwable t) {
            throw new RuntimeException(Messages.getString("RuntimeError.21", clazz.getName(), t.getMessage()), t);
        }
    }

    public static synchronized void forceJavaLogging() {
        LogFactory.setImplementation(new Jdk14LoggingLogFactory());
    }

    public static synchronized void forceSlf4jLogging() {
        LogFactory.setImplementation(new Slf4jLoggingLogFactory());
    }

    public static synchronized void forceCommonsLogging() {
        LogFactory.setImplementation(new JakartaCommonsLoggingLogFactory());
    }

    public static synchronized void forceLog4jLogging() {
        LogFactory.setImplementation(new Log4jLoggingLogFactory());
    }

    public static synchronized void forceLog4j2Logging() {
        LogFactory.setImplementation(new Log4j2LoggingLogFactory());
    }

    public static synchronized void forceNoLogging() {
        LogFactory.setImplementation(new NoLoggingLogFactory());
    }

    public static void setLogFactory(AbstractLogFactory logFactory) {
        LogFactory.setImplementation(logFactory);
    }

    private static void tryImplementation(AbstractLogFactory factory) {
        if (logFactory == null) {
            try {
                LogFactory.setImplementation(factory);
            }
            catch (LogException logException) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(AbstractLogFactory factory) {
        try {
            Log log = factory.getLog(LogFactory.class);
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + factory + "' adapter.");
            }
            logFactory = factory;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t.getMessage(), t);
        }
    }

    static {
        MARKER = "MYBATIS-GENERATOR";
        LogFactory.tryImplementation(new Slf4jLoggingLogFactory());
        LogFactory.tryImplementation(new JakartaCommonsLoggingLogFactory());
        LogFactory.tryImplementation(new Log4j2LoggingLogFactory());
        LogFactory.tryImplementation(new Log4jLoggingLogFactory());
        LogFactory.tryImplementation(new Jdk14LoggingLogFactory());
        LogFactory.tryImplementation(new NoLoggingLogFactory());
    }
}

