/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.plugins;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.ibatis2.Ibatis2FormattingUtilities;

public class CaseInsensitiveLikePlugin
extends PluginAdapter {
    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass criteria = null;
        for (InnerClass innerClass : topLevelClass.getInnerClasses()) {
            if (!"GeneratedCriteria".equals(innerClass.getType().getShortName())) continue;
            criteria = innerClass;
            break;
        }
        if (criteria == null) {
            return true;
        }
        for (IntrospectedColumn introspectedColumn : introspectedTable.getNonBLOBColumns()) {
            if (!introspectedColumn.isJdbcCharacterColumn() || !introspectedColumn.isStringColumn()) continue;
            Method method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value"));
            StringBuilder sb = new StringBuilder();
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            sb.insert(0, "and");
            sb.append("LikeInsensitive");
            method.setName(sb.toString());
            method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
            sb.setLength(0);
            sb.append("addCriterion(\"upper(");
            sb.append(Ibatis2FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
            sb.append(") like\", value.toUpperCase(), \"");
            sb.append(introspectedColumn.getJavaProperty());
            sb.append("\");");
            method.addBodyLine(sb.toString());
            method.addBodyLine("return (Criteria) this;");
            criteria.addMethod(method);
        }
        return true;
    }
}

