/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoParticipant;
import org.apache.ozhera.app.api.model.HeraAppBaseQuery;
import org.apache.ozhera.app.dao.mapper.HeraAppBaseInfoMapper;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.apache.ozhera.app.model.HeraAppBaseInfoExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class HeraBaseInfoDao {
    private static final Logger log = LoggerFactory.getLogger(HeraBaseInfoDao.class);
    @Resource
    private HeraAppBaseInfoMapper heraAppBaseInfoMapper;

    public Integer delById(Integer id) {
        if (id == null) {
            log.error("HeraBaseInfoDao.delById invalid param,id is null");
        }
        return this.heraAppBaseInfoMapper.deleteByPrimaryKey(id);
    }

    public Long countByParticipant(HeraAppBaseQuery query) {
        try {
            return this.heraAppBaseInfoMapper.countByParticipant(query);
        }
        catch (Exception e) {
            log.error("HeraBaseInfoDao#countByParticipant error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<HeraAppBaseInfoParticipant> queryByParticipant(HeraAppBaseQuery query) {
        query.initPageParam();
        try {
            return this.heraAppBaseInfoMapper.selectByParticipant(query);
        }
        catch (Exception e) {
            log.error("HeraBaseInfoDao#queryByParticipant error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Long count(HeraAppBaseInfoModel baseInfo) {
        HeraAppBaseInfoExample example = new HeraAppBaseInfoExample();
        HeraAppBaseInfoExample.Criteria ca = example.createCriteria();
        if (baseInfo.getStatus() != null) {
            ca.andStatusEqualTo(baseInfo.getStatus());
        } else {
            ca.andStatusEqualTo(0);
        }
        if (baseInfo.getBindId() != null) {
            ca.andBindIdEqualTo(baseInfo.getBindId());
        }
        if (baseInfo.getBindType() != null) {
            ca.andBindTypeEqualTo(baseInfo.getBindType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppName())) {
            ca.andAppNameLike("%" + baseInfo.getAppName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppCname())) {
            ca.andAppCnameLike("%" + baseInfo.getAppCname() + "%");
        }
        if (baseInfo.getAppType() != null) {
            ca.andAppTypeEqualTo(baseInfo.getAppType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppLanguage())) {
            ca.andAppLanguageLike("%" + baseInfo.getAppLanguage() + "%");
        }
        if (baseInfo.getPlatformType() != null) {
            ca.andPlatformTypeEqualTo(baseInfo.getPlatformType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppSignId())) {
            ca.andAppSignIdLike("%" + baseInfo.getAppSignId() + "%");
        }
        if (baseInfo.getIamTreeId() != null) {
            ca.andIamTreeIdEqualTo(baseInfo.getIamTreeId());
        }
        example.setOrderByClause("id desc");
        try {
            return this.heraAppBaseInfoMapper.countByExample(example);
        }
        catch (Exception e) {
            log.error("HeraBaseInfoDao#count error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<HeraAppBaseInfo> query(HeraAppBaseInfoModel baseInfo, Integer pageCount, Integer pageNum) {
        if (pageCount == null || pageCount <= 0) {
            pageCount = 1;
        }
        if (pageNum == null || pageNum <= 0) {
            pageNum = 10;
        }
        HeraAppBaseInfoExample example = new HeraAppBaseInfoExample();
        HeraAppBaseInfoExample.Criteria ca = example.createCriteria().andStatusEqualTo(0);
        if (baseInfo.getStatus() != null) {
            ca.andStatusEqualTo(baseInfo.getStatus());
        }
        if (baseInfo.getBindId() != null) {
            ca.andBindIdEqualTo(baseInfo.getBindId());
        }
        if (baseInfo.getBindType() != null) {
            ca.andBindTypeEqualTo(baseInfo.getBindType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppName())) {
            ca.andAppNameLike("%" + baseInfo.getAppName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppCname())) {
            ca.andAppCnameLike("%" + baseInfo.getAppCname() + "%");
        }
        if (baseInfo.getAppType() != null) {
            ca.andAppTypeEqualTo(baseInfo.getAppType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppLanguage())) {
            ca.andAppLanguageLike("%" + baseInfo.getAppLanguage() + "%");
        }
        if (baseInfo.getPlatformType() != null) {
            ca.andPlatformTypeEqualTo(baseInfo.getPlatformType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppSignId())) {
            ca.andAppSignIdLike("%" + baseInfo.getAppSignId() + "%");
        }
        if (baseInfo.getIamTreeId() != null) {
            ca.andIamTreeIdEqualTo(baseInfo.getIamTreeId());
        }
        example.setOffset((pageCount - 1) * pageNum);
        example.setLimit(pageNum);
        example.setOrderByClause("id desc");
        try {
            return this.heraAppBaseInfoMapper.selectByExampleWithBLOBs(example);
        }
        catch (Exception e) {
            log.error("HeraBaseInfoDao#query error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<HeraAppBaseInfo> searchAppsByIds(List<Integer> ids, HeraAppBaseInfoModel baseInfo, Integer pageCount, Integer pageNum) {
        if (pageCount == null || pageCount <= 0) {
            pageCount = 1;
        }
        if (pageNum == null || pageNum <= 0) {
            pageNum = 10;
        }
        HeraAppBaseInfoExample example = new HeraAppBaseInfoExample();
        HeraAppBaseInfoExample.Criteria ca = example.createCriteria().andStatusEqualTo(0);
        if (baseInfo.getStatus() != null) {
            ca.andStatusEqualTo(baseInfo.getStatus());
        }
        if (!CollectionUtils.isEmpty(ids)) {
            ca.andIdIn((List)ids);
        }
        if (baseInfo.getBindId() != null) {
            ca.andBindIdEqualTo(baseInfo.getBindId());
        }
        if (baseInfo.getBindType() != null) {
            ca.andBindTypeEqualTo(baseInfo.getBindType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppName())) {
            ca.andAppNameLike("%" + baseInfo.getAppName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppCname())) {
            ca.andAppCnameLike("%" + baseInfo.getAppCname() + "%");
        }
        if (baseInfo.getAppType() != null) {
            ca.andAppTypeEqualTo(baseInfo.getAppType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppLanguage())) {
            ca.andAppLanguageLike("%" + baseInfo.getAppLanguage() + "%");
        }
        if (baseInfo.getPlatformType() != null) {
            ca.andPlatformTypeEqualTo(baseInfo.getPlatformType());
        }
        if (StringUtils.isNotBlank((CharSequence)baseInfo.getAppSignId())) {
            ca.andAppSignIdLike("%" + baseInfo.getAppSignId() + "%");
        }
        if (baseInfo.getIamTreeId() != null) {
            ca.andIamTreeIdEqualTo(baseInfo.getIamTreeId());
        }
        example.setOffset((pageCount - 1) * pageNum);
        example.setLimit(pageNum);
        example.setOrderByClause("id desc");
        try {
            return this.heraAppBaseInfoMapper.selectByExampleWithBLOBs(example);
        }
        catch (Exception e) {
            log.error("HeraBaseInfoDao#searchAppsByIds error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Integer idByBindIdsAndPlat(String bindId, Integer platFormType) {
        if (StringUtils.isBlank((CharSequence)bindId) || platFormType == null) {
            log.error("idByBindIdsAndPlat param invalid!bindId:{},platFormType{}", (Object)bindId, (Object)platFormType);
            return null;
        }
        HeraAppBaseInfoExample example = new HeraAppBaseInfoExample();
        HeraAppBaseInfoExample.Criteria ca = example.createCriteria().andStatusEqualTo(0);
        ca.andBindIdEqualTo(bindId);
        ca.andPlatformTypeEqualTo(platFormType);
        try {
            List<HeraAppBaseInfo> heraAppBaseInfos = this.heraAppBaseInfoMapper.selectByExample(example);
            if (CollectionUtils.isEmpty(heraAppBaseInfos)) {
                return null;
            }
            return heraAppBaseInfos.get(0).getId();
        }
        catch (Exception e) {
            log.error("HeraBaseInfoDao#listAppsByBindIds error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public HeraAppBaseInfo getById(Integer id) {
        if (id == null) {
            log.info("HeraBaseInfoDao.getById id is null!");
            return null;
        }
        return this.heraAppBaseInfoMapper.selectByPrimaryKey(id);
    }

    public int create(HeraAppBaseInfo heraAppBaseInfo) {
        if (null == heraAppBaseInfo) {
            log.error("[HeraBaseInfoDao.create] null heraAppBaseInfo");
            return 0;
        }
        heraAppBaseInfo.setCreateTime(new Date());
        heraAppBaseInfo.setUpdateTime(new Date());
        heraAppBaseInfo.setStatus(0);
        try {
            int affected = this.heraAppBaseInfoMapper.insert(heraAppBaseInfo);
            if (affected < 1) {
                log.warn("[HeraBaseInfoDao.create] failed to insert heraAppBaseInfo: {}", (Object)heraAppBaseInfo.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[HeraBaseInfoDao.create] failed to insert heraAppBaseInfo: {}, err: {}", (Object)heraAppBaseInfo.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public int update(HeraAppBaseInfo heraAppBaseInfo) {
        if (null == heraAppBaseInfo) {
            log.error("[HeraBaseInfoDao.update] null heraAppBaseInfo");
            return 0;
        }
        heraAppBaseInfo.setUpdateTime(new Date());
        try {
            int affected = this.heraAppBaseInfoMapper.updateByPrimaryKeyWithBLOBs(heraAppBaseInfo);
            if (affected < 1) {
                log.warn("[HeraBaseInfoDao.update] failed to update heraAppBaseInfo: {}", (Object)heraAppBaseInfo.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[HeraBaseInfoDao.update] failed to update heraAppBaseInfo: {}, err: {}", (Object)heraAppBaseInfo.toString(), (Object)e);
            return 0;
        }
        return 1;
    }
}

