/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.model.vo.ResourceUserSimple;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.model.vo.LogStoreParam;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionService;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.impl.MilogMiddlewareConfigServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class StoreValidation {
    private static final Logger log = LoggerFactory.getLogger(StoreValidation.class);
    @Resource
    private MilogMiddlewareConfigServiceImpl milogMiddlewareConfigService;
    private StoreExtensionService storeExtensionService;
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Resource
    private EsCluster esCluster;
    @Value(value="$tpc.devMode")
    private String tpcDevMode;

    public void init() {
        this.storeExtensionService = StoreExtensionServiceFactory.getStoreExtensionService();
    }

    public String logStoreParamValid(LogStoreParam storeParam) {
        List<String> duplicatedKeyList;
        if (StringUtils.equals((CharSequence)"true", (CharSequence)this.tpcDevMode)) {
            return "";
        }
        if (null == MoneUserContext.getCurrentUser()) {
            throw new MilogManageException("please go to login");
        }
        ArrayList errorInfos = Lists.newArrayList();
        if (null == storeParam.getSpaceId()) {
            errorInfos.add("Space information cannot be empty");
        }
        if (null == storeParam || StringUtils.isBlank((CharSequence)storeParam.getLogstoreName())) {
            errorInfos.add("logStore  cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)storeParam.getMachineRoom())) {
            errorInfos.add("Computer room information  cannot be empty");
            return errorInfos.stream().collect(Collectors.joining(","));
        }
        if (null == storeParam.getLogType()) {
            errorInfos.add("Log type  cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)storeParam.getKeyList())) {
            errorInfos.add("Index columns  cannot be empty");
        }
        if (!(duplicatedKeyList = this.getDuplicatedKeys(storeParam.getKeyList())).isEmpty()) {
            errorInfos.add("Index column fields are duplicated, remove the duplicate fields:" + String.valueOf(duplicatedKeyList));
        }
        if (this.storeExtensionService.storeInfoCheck(storeParam)) {
            return errorInfos.stream().collect(Collectors.joining(","));
        }
        if (null == storeParam.getMqResourceId() || null == storeParam.getEsResourceId()) {
            boolean resourceChosen;
            ResourceUserSimple resourceUserSimple = this.milogMiddlewareConfigService.userResourceList(storeParam.getMachineRoom(), storeParam.getLogType());
            if (!resourceUserSimple.getInitializedFlag().booleanValue()) {
                errorInfos.add(resourceUserSimple.getNotInitializedMsg());
            }
            boolean bl = resourceChosen = null == storeParam.getMqResourceId() || null == storeParam.getEsResourceId();
            if (resourceUserSimple.getInitializedFlag().booleanValue() && resourceUserSimple.getShowFlag().booleanValue() && resourceChosen) {
                errorInfos.add("Please select the required resource information first");
            }
        } else {
            MilogEsClusterDO esClusterDO;
            MilogMiddlewareConfig milogMiddlewareConfig;
            if (null != storeParam.getMqResourceId() && null == (milogMiddlewareConfig = this.milogMiddlewareConfigDao.queryById(storeParam.getMqResourceId()))) {
                errorInfos.add("MQ resource information cannot be empty");
            }
            if (null != storeParam.getEsResourceId() && null == (esClusterDO = this.esCluster.getById(storeParam.getEsResourceId()))) {
                errorInfos.add("ES resource information cannot be empty");
            }
        }
        return errorInfos.stream().collect(Collectors.joining(","));
    }

    private List<String> getDuplicatedKeys(String keyListStr) {
        String[] keyList = keyListStr.split(",");
        ArrayList duplicatedKeys = Lists.newArrayList();
        HashMap keyMap = Maps.newHashMap();
        for (int i = 0; i < keyList.length; ++i) {
            String keyName = keyList[i].split(":")[0];
            if (keyMap.containsKey(keyName)) {
                duplicatedKeys.add(keyName);
                continue;
            }
            keyMap.put(keyName, true);
        }
        return duplicatedKeys;
    }
}

