/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessor;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessorFactory;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionService;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;

@Service
public class LogTail {
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private LogTailServiceImpl logTailService;
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private MilogLogTemplateMapper milogLogTemplateMapper;
    @Resource
    private LogTypeProcessorFactory logTypeProcessorFactory;
    private LogTypeProcessor logTypeProcessor;
    private TailExtensionService tailExtensionService;

    public void init() {
        this.logTypeProcessorFactory.setMilogLogTemplateMapper(this.milogLogTemplateMapper);
        this.logTypeProcessor = this.logTypeProcessorFactory.getLogTypeProcessor();
        this.tailExtensionService = TailExtensionServiceFactory.getTailExtensionService();
    }

    public void handleStoreTail(Long storeId) {
        MilogLogStoreDO milogLogStoreDO = this.logStoreDao.queryById(storeId);
        boolean supportedConsume = this.logTypeProcessor.supportedConsume(milogLogStoreDO.getLogType());
        List<MilogLogTailDo> milogLogtailDos = this.milogLogtailDao.queryTailsByStoreId(storeId);
        if (CollectionUtils.isNotEmpty(milogLogtailDos)) {
            milogLogtailDos.forEach(milogLogtailDo -> this.tailExtensionService.updateSendMsg((MilogLogTailDo)milogLogtailDo, milogLogtailDo.getIps(), supportedConsume));
        }
    }
}

