/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.model.dto.DictionaryDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.utils.PinYin4jUtils;

public interface MqConfigService {
    default public List<String> generateCommonTagTopicName(String orgId) {
        return IntStream.range(0, Constant.COMMON_MQ_SUFFIX.size()).mapToObj(value -> {
            String suffix = (String)Constant.COMMON_MQ_SUFFIX.get(value);
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                return String.format("%s_%s_%s", "common_mq_miLog", orgId, suffix);
            }
            return String.format("%s_%s", "common_mq_miLog", suffix);
        }).collect(Collectors.toList());
    }

    default public String generateSimpleTopicName(Long appId, String appName, String source, Long tailId) {
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            appName = PinYin4jUtils.getAllPinyin((String)appName);
        }
        List<String> collect = ReUtil.RE_KEYS.stream().map(character -> character.toString()).collect(Collectors.toList());
        String topicName = String.format("%s_%s_%s_%s", appId, appName, tailId, source);
        topicName = StrUtil.removeAny((CharSequence)topicName, (CharSequence[])collect.toArray(new String[0]));
        return topicName;
    }

    default public String generateSimpleTopicName(Long id, String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            name = PinYin4jUtils.getAllPinyin((String)name);
        }
        List<String> collect = ReUtil.RE_KEYS.stream().map(Object::toString).toList();
        String topicName = String.format("%s_%s", id, name);
        topicName = StrUtil.removeAny((CharSequence)topicName, (CharSequence[])collect.toArray(new String[0]));
        return topicName;
    }

    public MilogAppMiddlewareRel.Config generateConfig(String var1, String var2, String var3, String var4, String var5, String var6, String var7, Long var8, String var9, String var10, Long var11);

    public List<DictionaryDTO> queryExistsTopic(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public List<String> createCommonTagTopic(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public boolean CreateGroup(String var1, String var2, String var3);
}

