/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.StopWatch;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.mone.es.EsClient;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Service;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.model.dto.TraceLogDTO;
import org.apache.ozhera.log.api.model.vo.TraceLogQuery;
import org.apache.ozhera.log.api.service.LogDataService;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.utils.ManagerUtil;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.domain.SearchLog;
import org.apache.ozhera.log.manager.domain.TraceLog;
import org.apache.ozhera.log.manager.model.dto.EsStatisticResult;
import org.apache.ozhera.log.manager.model.dto.LogDTO;
import org.apache.ozhera.log.manager.model.dto.LogDataDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.vo.LogContextQuery;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.model.vo.RegionTraceLogQuery;
import org.apache.ozhera.log.manager.service.EsDataBaseService;
import org.apache.ozhera.log.manager.service.LogQueryService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mone.excel.ExportExcel;

@com.xiaomi.youpin.docean.anno.Service
@Service(interfaceClass=LogDataService.class)
public class LogQueryServiceImpl
implements LogQueryService,
LogDataService,
EsDataBaseService {
    private static final Logger log = LoggerFactory.getLogger(LogQueryServiceImpl.class);
    @Resource
    private MilogLogstoreDao logstoreDao;
    @Resource
    private EsCluster esCluster;
    @Resource
    private TraceLog traceLog;
    @Resource
    private SearchLog searchLog;
    private Set<String> noHighLightSet = new HashSet<String>();
    private Set<String> hidenFiledSet = new HashSet<String>();
    private CommonExtensionService commonExtensionService;

    public LogQueryServiceImpl() {
        this.noHighLightSet.add("logstore");
        this.noHighLightSet.add("logsource");
        this.noHighLightSet.add("tail");
        this.noHighLightSet.add("timestamp");
        this.noHighLightSet.add("linenumber");
        this.hidenFiledSet.add("mqtag");
        this.hidenFiledSet.add("mqtopic");
        this.hidenFiledSet.add("logstore");
        this.hidenFiledSet.add("linenumber");
        this.hidenFiledSet.add("filename");
    }

    public void init() {
        this.commonExtensionService = CommonExtensionServiceFactory.getCommonExtensionService();
    }

    @Override
    public Result<LogDTO> logQuery(LogQuery logQuery) {
        String logInfo = String.format("queryText:%s, user:%s, logQuery:%s", logQuery.getFullTextSearch(), MoneUserContext.getCurrentUser().getUser(), logQuery);
        log.info("query simple param:{}", (Object)logInfo);
        SearchRequest searchRequest = null;
        StopWatch stopWatch = new StopWatch("HERA-LOG-QUERY");
        try {
            stopWatch.start("before-query");
            MilogLogStoreDO logStore = this.logstoreDao.getByName(logQuery.getLogstore());
            if (logStore == null) {
                log.warn("[EsDataService.logQuery] not find logstore:[{}]", (Object)logQuery.getLogstore());
                return Result.failParam((String)("Not found [" + logQuery.getLogstore() + "]The corresponding data"));
            }
            EsService esService = this.esCluster.getEsService(logStore.getEsClusterId());
            String esIndexName = this.commonExtensionService.getSearchIndex(logQuery.getStoreId(), logStore.getEsIndex());
            if (esService == null || StringUtils.isEmpty((String)esIndexName)) {
                log.warn("[EsDataService.logQuery] logStore:[{}] Configuration exceptions", (Object)logQuery.getLogstore());
                return Result.failParam((String)"logStore configuration exception");
            }
            List<String> keyList = ManagerUtil.getKeyList(logStore.getKeyList(), logStore.getColumnTypeList());
            BoolQueryBuilder boolQueryBuilder = this.searchLog.getQueryBuilder(logQuery, ManagerUtil.getKeyColonPrefix(logStore.getKeyList()));
            SearchSourceBuilder builder = new SearchSourceBuilder();
            builder.query((QueryBuilder)boolQueryBuilder);
            LogDTO dto = new LogDTO();
            stopWatch.stop();
            stopWatch.start("bool-query");
            builder.sort(this.commonExtensionService.getSortedKey(logQuery, logQuery.getSortKey()), logQuery.getAsc() != false ? SortOrder.ASC : SortOrder.DESC);
            if (logQuery.getBeginSortValue() != null && logQuery.getBeginSortValue().length != 0) {
                builder.searchAfter(logQuery.getBeginSortValue());
            }
            builder.size(logQuery.getPageSize().intValue());
            builder.highlighter(this.getHighlightBuilder(keyList));
            builder.timeout(TimeValue.timeValueMinutes((long)1L));
            searchRequest = new SearchRequest(new String[]{esIndexName});
            searchRequest.source(builder);
            dto.setSourceBuilder(builder);
            SearchResponse searchResponse = esService.search(searchRequest);
            stopWatch.stop();
            if (stopWatch.getLastTaskTimeMillis() > 7000L) {
                log.warn("##LONG-COST-QUERY##{} cost:{} ms, msg:{}", new Object[]{stopWatch.getLastTaskName(), stopWatch.getLastTaskTimeMillis(), logInfo});
            }
            stopWatch.start("after-query");
            this.transformSearchResponse(searchResponse, dto, keyList);
            stopWatch.stop();
            if (stopWatch.getTotalTimeMillis() > 15000L) {
                log.warn("##LONG-COST-QUERY##{} cost:{} ms, msg:{}", new Object[]{"gt15s", stopWatch.getLastTaskTimeMillis(), logInfo});
            }
            return Result.success((Object)dto);
        }
        catch (ElasticsearchStatusException e) {
            log.error("Log query error, log search error, error type[{}], logQuery:[{}], searchRequest:[{}], user:[{}]", new Object[]{e.status(), logQuery, searchRequest, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)"If the permissions of ES resources are configured incorrectly, check the username and password or token");
        }
        catch (Throwable e) {
            log.error("Log query errors and log search errors,logQuery:[{}],searchRequest:[{}],user:[{}]", new Object[]{logQuery, searchRequest, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)"Search term input error, please check");
        }
    }

    private void transformSearchResponse(SearchResponse searchResponse, LogDTO logDTO, List<String> keyList) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        if (hits == null || hits.length == 0) {
            return;
        }
        ArrayList logDataList = Lists.newArrayList();
        for (SearchHit hit : hits) {
            LogDataDTO logData = this.hit2DTO(hit, keyList);
            logData.setHighlight(this.getHightlinghtMap(hit));
            logDataList.add(logData);
        }
        logDTO.setThisSortValue(hits[hits.length - 1].getSortValues());
        logDTO.setLogDataDTOList(logDataList);
    }

    private HighlightBuilder getHighlightBuilder(List<String> keyList) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (String key : keyList) {
            if (this.noHighLightSet.contains(key)) continue;
            HighlightBuilder.Field highlightField = new HighlightBuilder.Field(key);
            highlightBuilder.field(highlightField);
        }
        return highlightBuilder;
    }

    @Override
    public Result<EsStatisticResult> EsStatistic(LogQuery logQuery) {
        try {
            EsStatisticResult result = new EsStatisticResult();
            result.setName(this.constractEsStatisticRet(logQuery));
            MilogLogStoreDO logStore = this.logstoreDao.getByName(logQuery.getLogstore());
            if (logStore == null) {
                return new Result(CommonError.UnknownError.getCode(), "not found logstore", null);
            }
            String interval = this.searchLog.esHistogramInterval(logQuery.getEndTime() - logQuery.getStartTime());
            EsService esService = this.esCluster.getEsService(logStore.getEsClusterId());
            String esIndex = logStore.getEsIndex();
            if (esService == null || StringUtils.isEmpty((String)esIndex)) {
                return Result.failParam((String)"Log Store or tail configuration exceptions");
            }
            if (!StringUtils.isEmpty((String)interval)) {
                BoolQueryBuilder queryBuilder = this.searchLog.getQueryBuilder(logQuery, ManagerUtil.getKeyColonPrefix(logStore.getKeyList()));
                EsClient.EsRet esRet = esService.dateHistogram(esIndex, interval, logQuery.getStartTime().longValue(), logQuery.getEndTime().longValue(), queryBuilder);
                result.setCounts(esRet.getCounts());
                result.setTimestamps(esRet.getTimestamps());
                result.setQueryBuilder(queryBuilder);
                result.calTotalCounts();
                return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), (Object)result);
            }
            return new Result(CommonError.UnknownError.getCode(), "The minimum time interval is 10s", null);
        }
        catch (ElasticsearchStatusException e) {
            log.error("Log query errors and log bar chart statistics report errors:[{}], Error type[{}], logQuery:[{}], user:[{}]", new Object[]{e, e.status(), logQuery, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)"If the permissions of ES resources are configured incorrectly, check the username and password or token");
        }
        catch (Exception e) {
            log.error("Log query errors and log bar chart statistics report errors[{}],logQuery:[{}],user:[{}]", new Object[]{e, logQuery, MoneUserContext.getCurrentUser(), e});
            return Result.failParam((String)"Search term input error, please check");
        }
    }

    private String constractEsStatisticRet(LogQuery logquery) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)logquery.getLogstore())) {
            sb.append("logstore:").append(logquery.getLogstore()).append(";");
        }
        if (!StringUtils.isEmpty((String)logquery.getFullTextSearch())) {
            sb.append("fullTextSearch:").append(logquery.getFullTextSearch()).append(";");
        }
        return sb.toString();
    }

    private String esHistogramInterval(Long duration) {
        if ((duration = Long.valueOf(duration / 1000L)) > 86400L) {
            duration = duration / 100L;
            return duration + "s";
        }
        if (duration > 43200L) {
            duration = duration / 80L;
            return duration + "s";
        }
        if (duration > 21600L) {
            duration = duration / 60L;
            return duration + "s";
        }
        if (duration > 3600L) {
            duration = duration / 50L;
            return duration + "s";
        }
        if (duration > 1800L) {
            duration = duration / 40L;
            return duration + "s";
        }
        if (duration > 600L) {
            duration = duration / 30L;
            return duration + "s";
        }
        if (duration > 300L) {
            duration = duration / 25L;
            return duration + "s";
        }
        if (duration > 180L) {
            duration = duration / 20L;
            return duration + "s";
        }
        if (duration > 60L) {
            duration = duration / 15L;
            return duration + "s";
        }
        if (duration > 10L) {
            duration = duration / 10L;
            return duration + "s";
        }
        return "";
    }

    public TraceLogDTO getTraceLog(TraceLogQuery logQuery) {
        try {
            log.info("getTraceLog,param data:{}", (Object)Constant.GSON.toJson((Object)logQuery));
            return this.traceLog.getTraceLog(logQuery.getAppId(), logQuery.getTraceId(), "", logQuery.getGenerationTime(), logQuery.getLevel());
        }
        catch (Exception e) {
            log.error("Log query error, query trace log error, logQuery:[{}]", new Object[]{e, Constant.GSON.toJson((Object)logQuery), e});
            return TraceLogDTO.emptyData();
        }
    }

    @Override
    public Result<TraceLogDTO> queryRegionTraceLog(RegionTraceLogQuery regionTraceLogQuery) throws IOException {
        return Result.success((Object)this.traceLog.getTraceLog(null, regionTraceLogQuery.getTraceId(), regionTraceLogQuery.getRegion(), "", ""));
    }

    @Override
    public Result<LogDTO> getDocContext(LogContextQuery logContextQuery) {
        SearchRequest searchRequest = null;
        try {
            if (!this.searchLog.isLegalParam(logContextQuery)) {
                return Result.failParam((String)"Required parameters are missing");
            }
            MilogLogStoreDO logStore = this.logstoreDao.getByName(logContextQuery.getLogstore());
            if (logStore.getEsClusterId() == null || StringUtils.isEmpty((String)logStore.getEsIndex())) {
                return Result.failParam((String)"Store configuration exception");
            }
            EsService esService = this.esCluster.getEsService(logStore.getEsClusterId());
            String esIndexName = logStore.getEsIndex();
            List<String> keyList = ManagerUtil.getKeyList(logStore.getKeyList(), logStore.getColumnTypeList());
            LogDTO dto = new LogDTO();
            ArrayList<LogDataDTO> logDataList = new ArrayList<LogDataDTO>();
            int times = 1;
            int pageSize = logContextQuery.getPageSize();
            Long lineNumberSearchAfter = logContextQuery.getLineNumber();
            ArrayList<Integer> logOrder = new ArrayList<Integer>();
            logOrder.add(logContextQuery.getType());
            if (0 == logContextQuery.getType()) {
                times = 2;
                pageSize /= 2;
                logOrder.remove(0);
                logOrder.add(2);
                logOrder.add(1);
            }
            for (int t = 0; t < times; ++t) {
                int i;
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"logip", (String)logContextQuery.getIp()));
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"filename", (String)logContextQuery.getFileName()));
                SearchSourceBuilder builder = new SearchSourceBuilder();
                builder.query((QueryBuilder)boolQueryBuilder);
                if (1 == (Integer)logOrder.get(t)) {
                    builder.sort("timestamp", SortOrder.ASC);
                    builder.sort("linenumber", SortOrder.ASC);
                } else if (2 == (Integer)logOrder.get(t)) {
                    builder.sort("timestamp", SortOrder.DESC);
                    builder.sort("linenumber", SortOrder.DESC);
                }
                if (0 == logContextQuery.getType() && 2 == (Integer)logOrder.get(t)) {
                    builder.searchAfter(new Object[]{logContextQuery.getTimestamp(), lineNumberSearchAfter + 1L});
                } else {
                    builder.searchAfter(new Object[]{logContextQuery.getTimestamp(), lineNumberSearchAfter});
                }
                builder.size(pageSize);
                searchRequest = new SearchRequest(new String[]{esIndexName});
                searchRequest.source(builder);
                SearchResponse searchResponse = esService.search(searchRequest);
                SearchHit[] hits = searchResponse.getHits().getHits();
                if (hits == null || hits.length == 0) continue;
                if (1 == (Integer)logOrder.get(t)) {
                    for (i = 0; i < hits.length; ++i) {
                        logDataList.add(this.hit2DTO(hits[i], keyList));
                    }
                    continue;
                }
                if (2 != (Integer)logOrder.get(t)) continue;
                for (i = hits.length - 1; i >= 0; --i) {
                    logDataList.add(this.hit2DTO(hits[i], keyList));
                }
            }
            dto.setLogDataDTOList(logDataList);
            return Result.success((Object)dto);
        }
        catch (Exception e) {
            log.error("Log query error and log context error:[{}], logContextQuery:[{}], searchRequest:[{}], user:[{}]", new Object[]{e, logContextQuery, searchRequest, MoneUserContext.getCurrentUser()});
            return Result.failParam((String)"System error, please try again");
        }
    }

    private LogDataDTO hit2DTO(SearchHit hit, List<String> keyList) {
        LogDataDTO logData = new LogDataDTO();
        Map ferry = hit.getSourceAsMap();
        long time = 0L;
        if (ferry.containsKey("time") && null != ferry.get("time") && StringUtils.isNotBlank((String)ferry.get("time").toString())) {
            time = DateUtil.parse((CharSequence)ferry.get("time").toString()).toTimestamp().getTime();
        }
        if (null == ferry.get("timestamp")) {
            logData.setValue("timestamp", time);
        } else {
            logData.setValue("timestamp", ferry.get("timestamp"));
        }
        for (String key : keyList) {
            if (this.hidenFiledSet.contains(key)) continue;
            logData.setValue(key, ferry.get(key));
        }
        logData.setIp(ferry.get("logip") == null ? "" : String.valueOf(ferry.get("logip")));
        logData.setFileName(ferry.get("filename") == null ? "" : String.valueOf(ferry.get("filename")));
        logData.setLineNumber(ferry.get("linenumber") == null ? "" : String.valueOf(ferry.get("linenumber")));
        logData.setTimestamp(ferry.get("timestamp") == null ? String.valueOf(time) : String.valueOf(ferry.get("timestamp")));
        logData.setLogOfString(new Gson().toJson(logData.getLogOfKV()));
        return logData;
    }

    @Override
    public void logExport(LogQuery logQuery) throws Exception {
        int maxLogNum = 10000;
        logQuery.setPageSize(maxLogNum);
        Result<LogDTO> logDTOResult = this.logQuery(logQuery);
        List exportData = logDTOResult.getCode() != CommonError.Success.getCode() || ((LogDTO)logDTOResult.getData()).getLogDataDTOList() == null || ((LogDTO)logDTOResult.getData()).getLogDataDTOList().isEmpty() ? null : ((LogDTO)logDTOResult.getData()).getLogDataDTOList().stream().map(LogDataDTO::getLogOfKV).collect(Collectors.toList());
        HSSFWorkbook excel = ExportExcel.HSSFWorkbook4Map(exportData, (String)this.generateTitle(logQuery));
        String fileName = String.format("%s_log.xls", logQuery.getLogstore());
        this.searchLog.downLogFile(excel, fileName);
    }

    private String generateTitle(LogQuery logQuery) {
        return String.format("%s Logs, search terms:[%s],time range %d-%d", logQuery.getLogstore(), logQuery.getFullTextSearch() == null ? "" : logQuery.getFullTextSearch(), logQuery.getStartTime(), logQuery.getEndTime());
    }
}

