/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.nacos.api.config.ConfigService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.xiaomi.data.push.nacos.NacosNaming;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.common.Utils;
import org.apache.ozhera.log.manager.dao.MilogAppMiddlewareRelDao;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.MilogConfigNacosService;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessor;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessorFactory;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.store.DorisLogStorageService;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionService;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.nacos.DynamicConfigProvider;
import org.apache.ozhera.log.manager.service.nacos.DynamicConfigPublisher;
import org.apache.ozhera.log.manager.service.nacos.FetchStreamMachineService;
import org.apache.ozhera.log.manager.service.nacos.MultipleNacosConfig;
import org.apache.ozhera.log.manager.service.nacos.impl.NacosFetchStreamMachineService;
import org.apache.ozhera.log.manager.service.nacos.impl.SpaceConfigNacosProvider;
import org.apache.ozhera.log.manager.service.nacos.impl.SpaceConfigNacosPublisher;
import org.apache.ozhera.log.manager.service.nacos.impl.StreamConfigNacosProvider;
import org.apache.ozhera.log.manager.service.nacos.impl.StreamConfigNacosPublisher;
import org.apache.ozhera.log.model.LogtailConfig;
import org.apache.ozhera.log.model.MiLogStreamConfig;
import org.apache.ozhera.log.model.MilogSpaceData;
import org.apache.ozhera.log.model.SinkConfig;
import org.apache.ozhera.log.model.StorageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogConfigNacosServiceImpl
implements MilogConfigNacosService {
    private static final Logger log = LoggerFactory.getLogger(MilogConfigNacosServiceImpl.class);
    private static Map<String, DynamicConfigPublisher> configPublisherMap = new HashedMap();
    private static Map<String, DynamicConfigProvider> configProviderMap = new HashedMap();
    private static Map<String, FetchStreamMachineService> streamServiceUniqueMap = new HashedMap();
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private EsCluster esCluster;
    @Resource
    private MilogAppMiddlewareRelDao milogAppMiddlewareRelDao;
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Resource
    private DorisLogStorageService dorisLogStorageService;
    @Value(value="$europe.ip.key")
    private String europeIpKey;
    @Value(value="$app.env")
    private String appEnv;
    @Resource
    private MilogLogTemplateMapper milogLogTemplateMapper;
    @Resource
    private LogTypeProcessorFactory logTypeProcessorFactory;
    private TailExtensionService tailExtensionService;
    private LogTypeProcessor logTypeProcessor;
    private CommonExtensionService commonExtensionService;

    public void init() {
        this.tailExtensionService = TailExtensionServiceFactory.getTailExtensionService();
        this.commonExtensionService = CommonExtensionServiceFactory.getCommonExtensionService();
        this.logTypeProcessorFactory.setMilogLogTemplateMapper(this.milogLogTemplateMapper);
        this.logTypeProcessor = this.logTypeProcessorFactory.getLogTypeProcessor();
        this.initializeNacosConfigurations();
    }

    private void initializeNacosConfigurations() {
        List<String> regions = this.commonExtensionService.queryMachineRegions();
        for (String region : regions) {
            this.chooseCurrentEnvNacosService(region);
        }
    }

    public StreamConfigNacosPublisher getStreamConfigNacosPublisher(String motorRoomEn) {
        return (StreamConfigNacosPublisher)configPublisherMap.get("stream" + motorRoomEn);
    }

    public StreamConfigNacosProvider getStreamConfigNacosProvider(String motorRoomEn) {
        return (StreamConfigNacosProvider)configProviderMap.get("stream" + motorRoomEn);
    }

    public SpaceConfigNacosPublisher getSpaceConfigNacosPublisher(String motorRoomEn) {
        return (SpaceConfigNacosPublisher)configPublisherMap.get("space" + motorRoomEn);
    }

    public SpaceConfigNacosProvider getSpaceConfigNacosProvider(String motorRoomEn) {
        return (SpaceConfigNacosProvider)configProviderMap.get("space" + motorRoomEn);
    }

    public FetchStreamMachineService getFetchStreamMachineService(String motorRoomEn) {
        return streamServiceUniqueMap.get("stream" + motorRoomEn);
    }

    @Override
    public void publishStreamConfig(Long spaceId, Integer type, Integer projectTypeCode, String motorRoomEn) {
        List<String> mioneStreamIpList = this.tailExtensionService.fetchStreamUniqueKeyList(this.getFetchStreamMachineService(motorRoomEn), spaceId, motorRoomEn);
        log.info("Query the list of machines in log-stream\uff1a{}", (Object)new Gson().toJson(mioneStreamIpList));
        this.getStreamConfigNacosPublisher(motorRoomEn).publish(spaceId, this.dealStreamConfigByRule(motorRoomEn, mioneStreamIpList, spaceId, type));
        this.tailExtensionService.publishStreamConfigPostProcess(this.getStreamConfigNacosPublisher(motorRoomEn), spaceId, motorRoomEn);
    }

    private synchronized MiLogStreamConfig dealStreamConfigByRule(String motorRoomEn, List<String> ipList, Long spaceId, Integer type) {
        Map<String, HashMap> config;
        MiLogStreamConfig existConfig = this.getStreamConfigNacosProvider(motorRoomEn).getConfig(spaceId);
        ipList = this.ensureDefaultCompatibility(existConfig, ipList);
        String spaceKey = CommonExtensionServiceFactory.getCommonExtensionService().getLogManagePrefix() + "create_tail_config:" + spaceId;
        if (null == existConfig || OperateEnum.ADD_OPERATE.getCode().equals(type) || OperateEnum.UPDATE_OPERATE.getCode().equals(type)) {
            if (null == existConfig) {
                existConfig = new MiLogStreamConfig();
                config = new HashMap();
                boolean idAdd = false;
                for (String ip : ipList) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)1);
                    if (!idAdd) {
                        map.put(spaceId, spaceKey);
                        idAdd = true;
                    }
                    config.put(ip, map);
                }
                existConfig.setConfig(config);
            } else {
                config = existConfig.getConfig();
                if (config.values().stream().flatMap(longStringMap -> longStringMap.values().stream()).anyMatch(s -> s.equals(spaceKey))) {
                    return existConfig;
                }
                if (CollectionUtils.isNotEmpty(ipList)) {
                    for (String ip : ipList) {
                        if (config.containsKey(ip)) continue;
                        config.put(ip, Maps.newHashMap());
                    }
                }
                Map<String, Integer> ipSizeMap = config.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, stringMapEntry -> ((Map)stringMapEntry.getValue()).size()));
                List<String> finalIpList = ipList;
                String key = (String)ipSizeMap.entrySet().stream().filter(entry -> finalIpList.contains(entry.getKey())).min(Map.Entry.comparingByValue()).get().getKey();
                ((Map)config.get(key)).put(spaceId, spaceKey);
            }
        }
        if (OperateEnum.DELETE_OPERATE.getCode().equals(type)) {
            if (null != existConfig) {
                config = existConfig.getConfig();
                config.values().forEach(longStringMap -> longStringMap.keySet().removeIf(key -> key.equals(spaceId)));
            }
            this.getSpaceConfigNacosPublisher(motorRoomEn).remove(spaceId.toString());
        }
        return existConfig;
    }

    private List<String> ensureDefaultCompatibility(MiLogStreamConfig existConfig, List<String> ipList) {
        Set keySet = existConfig.getConfig().keySet();
        if (!CollectionUtils.isEqualCollection(keySet, ipList)) {
            log.info("ipList not belong to config,query list:{},actual list:{}", (Object)Constant.GSON.toJson(ipList), (Object)Constant.GSON.toJson(keySet));
            ipList = keySet.stream().toList();
        }
        return ipList;
    }

    @Override
    public void publishNameSpaceConfig(String motorRoomEn, Long spaceId, Long storeId, Long tailId, Integer type, String changeType) {
        Assert.notNull((Object)spaceId, (String)"logSpaceId not empty", (Object[])new Object[0]);
        Assert.notNull((Object)storeId, (String)"storeId not empty", (Object[])new Object[0]);
        this.getSpaceConfigNacosPublisher(motorRoomEn).publish(spaceId, this.dealSpaceConfigByRule(motorRoomEn, spaceId, storeId, tailId, type, changeType));
    }

    public void chooseCurrentEnvNacosService(String motorRoomEn) {
        MilogMiddlewareConfig middlewareConfig = this.milogMiddlewareConfigDao.queryCurrentEnvNacos(motorRoomEn);
        if (null != middlewareConfig) {
            NacosFetchStreamMachineService fetchStreamMachineService;
            StreamConfigNacosProvider streamConfigNacosProvider;
            SpaceConfigNacosProvider spaceConfigNacosProvider;
            StreamConfigNacosPublisher streamConfigNacosPublisher;
            ConfigService configService = MultipleNacosConfig.getConfigService(middlewareConfig.getNameServer());
            SpaceConfigNacosPublisher spaceConfigNacosPublisher = (SpaceConfigNacosPublisher)configPublisherMap.get("space" + motorRoomEn);
            if (null == spaceConfigNacosPublisher) {
                spaceConfigNacosPublisher = new SpaceConfigNacosPublisher();
                spaceConfigNacosPublisher.setConfigService(configService);
                configPublisherMap.put("space" + motorRoomEn, spaceConfigNacosPublisher);
            }
            if (null == (streamConfigNacosPublisher = (StreamConfigNacosPublisher)configPublisherMap.get("stream" + motorRoomEn))) {
                streamConfigNacosPublisher = new StreamConfigNacosPublisher();
                streamConfigNacosPublisher.setConfigService(configService);
                configPublisherMap.put("stream" + motorRoomEn, streamConfigNacosPublisher);
            }
            if (null == (spaceConfigNacosProvider = (SpaceConfigNacosProvider)configProviderMap.get("space" + motorRoomEn))) {
                spaceConfigNacosProvider = new SpaceConfigNacosProvider();
                spaceConfigNacosProvider.setConfigService(configService);
                configProviderMap.put("space" + motorRoomEn, spaceConfigNacosProvider);
            }
            if (null == (streamConfigNacosProvider = (StreamConfigNacosProvider)configProviderMap.get("stream" + motorRoomEn))) {
                streamConfigNacosProvider = new StreamConfigNacosProvider();
                streamConfigNacosProvider.setConfigService(configService);
                configProviderMap.put("stream" + motorRoomEn, streamConfigNacosProvider);
            }
            if (null == (fetchStreamMachineService = (NacosFetchStreamMachineService)streamServiceUniqueMap.get("stream" + motorRoomEn))) {
                NacosNaming nacosNaming = MultipleNacosConfig.getNacosNaming(middlewareConfig.getNameServer());
                fetchStreamMachineService = new NacosFetchStreamMachineService(nacosNaming);
                streamServiceUniqueMap.put("stream" + motorRoomEn, fetchStreamMachineService);
            }
        } else {
            log.info("Current data center: {} does not have NACOS configuration information", (Object)motorRoomEn);
        }
    }

    @Override
    public void removeStreamConfig(String motorRoomEn, Long id) {
        this.getSpaceConfigNacosPublisher(motorRoomEn).remove("" + id);
    }

    private synchronized MilogSpaceData dealSpaceConfigByRule(String motorRoomEn, Long spaceId, Long storeId, Long tailId, Integer type, String changeType) {
        SinkConfig currentStoreConfig;
        List spaceConfig;
        MilogSpaceData existConfig = this.getSpaceConfigNacosProvider(motorRoomEn).getConfig(spaceId);
        if (null == existConfig || OperateEnum.ADD_OPERATE.getCode().equals(type)) {
            if (null == existConfig || CollectionUtils.isEmpty((Collection)existConfig.getSpaceConfig())) {
                existConfig = new MilogSpaceData();
                existConfig.setMilogSpaceId(spaceId);
                ArrayList spaceConfigs = Lists.newArrayList();
                spaceConfigs.add(this.assembleSinkConfig(storeId, tailId, motorRoomEn));
                existConfig.setSpaceConfig((List)spaceConfigs);
            } else {
                spaceConfig = existConfig.getSpaceConfig();
                currentStoreConfig = spaceConfig.stream().filter(sinkConfig -> sinkConfig.getLogstoreId().equals(storeId)).findFirst().orElse(null);
                existConfig.setMilogSpaceId(spaceId);
                if (null != currentStoreConfig) {
                    List logtailConfigs = currentStoreConfig.getLogtailConfigs();
                    if (CollectionUtils.isEmpty((Collection)logtailConfigs)) {
                        logtailConfigs = Lists.newArrayList();
                    }
                    logtailConfigs.add(this.assembleLogTailConfigs(tailId));
                    currentStoreConfig.setLogtailConfigs(logtailConfigs);
                } else {
                    spaceConfig.add(this.assembleSinkConfig(storeId, tailId, motorRoomEn));
                }
            }
        }
        if (OperateEnum.DELETE_OPERATE.getCode().equals(type) && !"log-store".equalsIgnoreCase(changeType) && null != existConfig && null != (currentStoreConfig = (SinkConfig)(spaceConfig = existConfig.getSpaceConfig()).stream().filter(sinkConfig -> sinkConfig.getLogstoreId().equals(storeId)).findFirst().orElse(null))) {
            List logTailConfigs = currentStoreConfig.getLogtailConfigs();
            ArrayList<LogtailConfig> logtailConfigList = new ArrayList<LogtailConfig>(logTailConfigs);
            if (null != tailId && CollectionUtils.isNotEmpty((Collection)logTailConfigs) && logTailConfigs.stream().anyMatch(config -> config.getLogtailId().equals(tailId))) {
                logtailConfigList.removeIf(logtailConfig -> logtailConfig.getLogtailId().equals(tailId));
            }
            currentStoreConfig.setLogtailConfigs(logtailConfigList);
        }
        if (OperateEnum.DELETE_OPERATE.getCode().equals(type) && "log-store".equalsIgnoreCase(changeType) && null != existConfig) {
            List sinkConfigListDelStore = existConfig.getSpaceConfig().stream().filter(sinkConfig -> !storeId.equals(sinkConfig.getLogstoreId())).collect(Collectors.toList());
            existConfig.setSpaceConfig(sinkConfigListDelStore);
        }
        if (OperateEnum.UPDATE_OPERATE.getCode().equals(type) && null != existConfig) {
            spaceConfig = existConfig.getSpaceConfig();
            SinkConfig newSinkConfig = this.assembleSinkConfig(storeId, tailId, motorRoomEn);
            SinkConfig currentStoreConfig2 = spaceConfig.stream().filter(sinkConfig -> sinkConfig.getLogstoreId().equals(storeId)).findFirst().orElse(null);
            if (null != currentStoreConfig2) {
                LogtailConfig filterLogTailConfig;
                if (!newSinkConfig.equals((Object)currentStoreConfig2)) {
                    currentStoreConfig2.updateStoreParam(newSinkConfig);
                }
                if (null != (filterLogTailConfig = (LogtailConfig)currentStoreConfig2.getLogtailConfigs().stream().filter(logTailConfig -> Objects.equals(tailId, logTailConfig.getLogtailId())).findFirst().orElse(null))) {
                    BeanUtil.copyProperties((Object)this.assembleLogTailConfigs(tailId), (Object)filterLogTailConfig, (String[])new String[0]);
                } else {
                    log.info("query logtailConfig no designed config,tailId:{},insert", (Object)tailId);
                    currentStoreConfig2.getLogtailConfigs().add(this.assembleLogTailConfigs(tailId));
                }
            } else {
                spaceConfig.add(this.assembleSinkConfig(storeId, tailId, motorRoomEn));
            }
        }
        return existConfig;
    }

    public SinkConfig assembleSinkConfig(Long storeId, Long tailId, String motorRoomEn) {
        SinkConfig sinkConfig = new SinkConfig();
        sinkConfig.setLogstoreId(storeId);
        MilogLogStoreDO logStoreDO = this.logStoreDao.queryById(storeId);
        if (null != logStoreDO) {
            boolean supportedConsume = this.logTypeProcessor.supportedConsume(logStoreDO.getLogType());
            if (!supportedConsume) {
                return sinkConfig;
            }
            sinkConfig.setLogstoreName(logStoreDO.getLogstoreName());
            sinkConfig.setKeyList(Utils.parse2KeyAndTypeList(logStoreDO.getKeyList(), logStoreDO.getColumnTypeList()));
            MilogEsClusterDO esInfo = this.esCluster.getById(logStoreDO.getEsClusterId());
            if (null != esInfo) {
                sinkConfig.setEsIndex(logStoreDO.getEsIndex());
                sinkConfig.setEsInfo(this.buildEsInfo(esInfo));
                sinkConfig.setStorageType(esInfo.getLogStorageType());
                LogStorageTypeEnum storageTypeEnum = LogStorageTypeEnum.queryByName((String)esInfo.getLogStorageType());
                if (LogStorageTypeEnum.DORIS == storageTypeEnum) {
                    sinkConfig.setColumnList(this.dorisLogStorageService.getColumnList(logStoreDO.getEsClusterId(), logStoreDO.getEsIndex()));
                }
            } else {
                log.info("assembleSinkConfig esInfo is null,logStoreId:{}", (Object)logStoreDO.getId());
            }
        }
        sinkConfig.setLogtailConfigs(Arrays.asList(this.assembleLogTailConfigs(tailId)));
        return sinkConfig;
    }

    private StorageInfo buildEsInfo(MilogEsClusterDO clusterDO) {
        if (Objects.equals("pwd", clusterDO.getConWay())) {
            return new StorageInfo(clusterDO.getId(), clusterDO.getAddr(), clusterDO.getUser(), clusterDO.getPwd());
        }
        return new StorageInfo(clusterDO.getId(), clusterDO.getAddr(), clusterDO.getToken(), clusterDO.getDtCatalog(), clusterDO.getDtDatabase());
    }

    public LogtailConfig assembleLogTailConfigs(Long tailId) {
        LogtailConfig logtailConfig = new LogtailConfig();
        MilogLogTailDo milogLogTail = this.milogLogtailDao.queryById(tailId);
        if (null != milogLogTail) {
            logtailConfig.setLogtailId(tailId);
            logtailConfig.setTail(milogLogTail.getTail());
            logtailConfig.setParseType(milogLogTail.getParseType());
            logtailConfig.setParseScript(milogLogTail.getParseScript());
            logtailConfig.setValueList(milogLogTail.getValueList());
            logtailConfig.setAppType(milogLogTail.getAppType());
            this.handleTailConfig(tailId, milogLogTail.getStoreId(), milogLogTail.getSpaceId(), milogLogTail.getMilogAppId(), logtailConfig, milogLogTail.getAppType());
        }
        return logtailConfig;
    }

    private void handleTailConfig(Long tailId, Long storeId, Long spaceId, Long milogAppId, LogtailConfig logtailConfig, Integer appType) {
        List<MilogAppMiddlewareRel> milogAppMiddlewareRels = this.milogAppMiddlewareRelDao.queryByCondition(milogAppId, null, tailId);
        if (CollectionUtils.isNotEmpty(milogAppMiddlewareRels)) {
            MilogAppMiddlewareRel milogAppMiddlewareRel = milogAppMiddlewareRels.get(0);
            MilogAppMiddlewareRel.Config config = milogAppMiddlewareRel.getConfig();
            MilogMiddlewareConfig middlewareConfig = this.milogMiddlewareConfigDao.queryById(milogAppMiddlewareRel.getMiddlewareId());
            logtailConfig.setAk(middlewareConfig.getAk());
            logtailConfig.setSk(middlewareConfig.getSk());
            logtailConfig.setTopic(config.getTopic());
            String tag = Utils.createTag(spaceId, storeId, tailId);
            logtailConfig.setTag(tag);
            logtailConfig.setConsumerGroup(config.getConsumerGroup());
            logtailConfig.setType(MQSourceEnum.queryName((Integer)middlewareConfig.getType()));
            logtailConfig.setClusterInfo(middlewareConfig.getNameServer());
            TailExtensionServiceFactory.getTailExtensionService().logTailConfigExtraField(logtailConfig, middlewareConfig);
        }
    }
}

